/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.persistence;

import java.io.Serializable;
import java.util.Calendar;
import java.util.List;
import java.util.UUID;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.analysis.statisticalmanager.SMOperationStatus;
import org.gcube.data.analysis.statisticalmanager.SMOperationType;
import org.gcube.data.analysis.statisticalmanager.SMResourceType;
import org.gcube.data.analysis.statisticalmanager.persistence.DataBaseManager;
import org.gcube.data.analysis.statisticalmanager.persistence.HibernateManager;
import org.gcube.data.analysis.statisticalmanager.stubs.SMComputationRequest;
import org.gcube.data.analysis.statisticalmanager.stubs.SMComputations;
import org.gcube.data.analysis.statisticalmanager.stubs.SMCreateTableRequest;
import org.gcube.dataanalysis.ecoengine.configuration.INFRASTRUCTURE;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMAbstractResource;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMComputation;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMEntries;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMEntry;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMError;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMFile;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMImport;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMInputEntry;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMObject;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMOperation;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMResource;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMSystemImport;
import org.hibernate.Query;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;

public class SMPersistenceManager {
    private static GCUBELog logger = new GCUBELog(SMPersistenceManager.class);

    public static long addImporter(SMCreateTableRequest request) throws Exception {
        Session session = HibernateManager.getSessionFactory().openSession();
        Transaction t = session.beginTransaction();
        try {
            SMImport smimport = new SMImport();
            smimport.setFileName(request.getTableName());
            smimport.setOperationType(SMOperationType.IMPORTED.ordinal());
            smimport.setPortalLogin(request.getUser());
            smimport.setSubmissionDate(Calendar.getInstance());
            smimport.setDescription(request.getDescription());
            smimport.setOperationStatus(SMOperationStatus.RUNNING.ordinal());
            session.save((Object)smimport);
            t.commit();
            long l = smimport.getOperationId();
            return l;
        }
        catch (Exception e) {
            HibernateManager.roolbackTransaction(t);
            throw new Exception();
        }
        finally {
            HibernateManager.closeSession((org.hibernate.Session)session);
        }
    }

    public static void addCreatedResource(SMResource resource) throws Exception {
        Session session = HibernateManager.getSessionFactory().openSession();
        Transaction t = session.beginTransaction();
        try {
            if (session.get(SMResource.class, (Serializable)((Object)resource.getResourceId())) == null) {
                session.save((Object)resource);
            }
            t.commit();
        }
        catch (Exception e) {
            HibernateManager.roolbackTransaction(t);
            throw new Exception();
        }
        finally {
            HibernateManager.closeSession((org.hibernate.Session)session);
        }
    }

    public static long addSystemImporter(String description, SMResource resource) throws Exception {
        Session session = HibernateManager.getSessionFactory().openSession();
        Transaction t = session.beginTransaction();
        try {
            SMSystemImport smimport = new SMSystemImport();
            smimport.setOperationType(SMOperationType.SYSTEM.ordinal());
            smimport.setSubmissionDate(Calendar.getInstance());
            smimport.setDescription(description);
            session.save((Object)resource);
            SMAbstractResource ar = new SMAbstractResource();
            ar.setResource(resource);
            ar.setAbstractResourceId(resource.getResourceId());
            session.save((Object)ar);
            smimport.setAbstractResource(ar);
            smimport.setOperationStatus(SMOperationStatus.COMPLETED.ordinal());
            smimport.setCompletedDate(Calendar.getInstance());
            session.saveOrUpdate((Object)smimport);
            t.commit();
            long l = smimport.getOperationId();
            return l;
        }
        catch (Exception e) {
            HibernateManager.roolbackTransaction(t);
            throw new Exception();
        }
        finally {
            HibernateManager.closeSession((org.hibernate.Session)session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<SMResource> getResources(String user, String template) {
        Session session = HibernateManager.getSessionFactory().openSession();
        try {
            Query query = session.createQuery("select resource from SMResource resource where (resource.portalLogin like :name or resource.portalLogin = null) and resource.resourceType <> 2 and resource.resourceType <> 3 ");
            query.setParameter("name", (Object)(user != null ? user : "%"));
            List list = query.list();
            return list;
        }
        finally {
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SMOperation getOperation(long operationId) throws Exception {
        Session session = HibernateManager.getSessionFactory().openSession();
        try {
            SMOperation sMOperation = (SMOperation)session.get(SMOperation.class, (Serializable)Long.valueOf(operationId));
            return sMOperation;
        }
        finally {
            HibernateManager.closeSession((org.hibernate.Session)session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SMComputations getComputations(String user, String algorithm, String category) throws Exception {
        Session session = HibernateManager.getSessionFactory().openSession();
        try {
            Query query = session.createQuery("select computation from SMComputation  computation where computation.portalLogin like :name and computation.algorithm like :algorithm and computation.category like :category");
            query.setParameter("name", (Object)(user != null ? user : "%"));
            query.setParameter("algorithm", (Object)(algorithm != null ? algorithm : "%"));
            query.setParameter("category", (Object)(category != null ? category : "%"));
            List objects = query.list();
            for (Object object : objects) {
                SMComputation computation = (SMComputation)object;
                Query queryParameters = session.createQuery("select parameter from SMEntry parameter where parameter.computationId = :computationId");
                queryParameters.setParameter("computationId", (Object)computation.getOperationId());
                List parameters = queryParameters.list();
                if (parameters.isEmpty()) continue;
                computation.setParameters(parameters.toArray(new SMEntry[parameters.size()]));
            }
            SMComputation[] computations = objects.toArray(new SMComputation[objects.size()]);
            SMComputations sMComputations = new SMComputations(computations);
            return sMComputations;
        }
        finally {
            HibernateManager.closeSession((org.hibernate.Session)session);
        }
    }

    public static long addComputation(SMComputationRequest request, String category) throws Exception {
        Session session = HibernateManager.getSessionFactory().openSession();
        Transaction t = session.beginTransaction();
        try {
            SMComputation smcomputation = new SMComputation();
            smcomputation.setOperationType(SMOperationType.COMPUTED.ordinal());
            smcomputation.setPortalLogin(request.getUser());
            smcomputation.setSubmissionDate(Calendar.getInstance());
            smcomputation.setTitle(request.getTitle());
            smcomputation.setDescription(request.getDescription());
            String algorithm = request.getConfig().getAlgorithm();
            smcomputation.setAlgorithm(algorithm);
            smcomputation.setCategory(category);
            smcomputation.setOperationStatus(SMOperationStatus.PENDING.ordinal());
            session.save((Object)smcomputation);
            SMEntries parameters = request.getConfig().getParameters();
            if (parameters.getList() != null) {
                for (SMInputEntry parameter : parameters.getList()) {
                    SMEntry entry = new SMEntry();
                    entry.setKey(parameter.getKey());
                    entry.setValue(parameter.getValue());
                    entry.setComputationId(smcomputation.getOperationId());
                    session.save((Object)entry);
                }
            }
            t.commit();
            long l = smcomputation.getOperationId();
            return l;
        }
        catch (Exception e) {
            HibernateManager.roolbackTransaction(t);
            e.printStackTrace();
            throw new Exception();
        }
        finally {
            HibernateManager.closeSession((org.hibernate.Session)session);
        }
    }

    public static void addCreatedResource(long operationId, SMResource resource) throws Exception {
        logger.debug((Object)"------------------------------------------------------");
        Session session = HibernateManager.getSessionFactory().openSession();
        Transaction t = session.beginTransaction();
        try {
            SMOperation operation = (SMOperation)session.get(SMOperation.class, (Serializable)Long.valueOf(operationId));
            logger.debug((Object)("Resource type " + SMResourceType.values()[resource.getResourceType()]));
            switch (SMResourceType.values()[resource.getResourceType()]) {
                case OBJECT: {
                    SMObject object = (SMObject)resource;
                    session.save((Object)object);
                    logger.debug((Object)"Resource saved !!!!");
                    logger.debug((Object)"-----------------------------------------------------------");
                }
            }
            SMAbstractResource ar = new SMAbstractResource();
            ar.setResource(resource);
            ar.setAbstractResourceId(resource.getResourceId());
            session.save((Object)ar);
            operation.setAbstractResource(ar);
            operation.setOperationStatus(SMOperationStatus.COMPLETED.ordinal());
            operation.setCompletedDate(Calendar.getInstance());
            session.saveOrUpdate((Object)operation);
            t.commit();
        }
        catch (Exception e) {
            logger.debug((Object)"Error persistence ", (Throwable)e);
            HibernateManager.roolbackTransaction(t);
            throw new Exception();
        }
        finally {
            HibernateManager.closeSession((org.hibernate.Session)session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setOperationStatus(long operationId, SMOperationStatus status) {
        Session session = HibernateManager.getSessionFactory().openSession();
        Transaction t = session.beginTransaction();
        try {
            SMOperation smoperation = (SMOperation)session.get(SMOperation.class, (Serializable)Long.valueOf(operationId));
            smoperation.setOperationStatus(status.ordinal());
            if (status == SMOperationStatus.FAILED) {
                smoperation.setCompletedDate(Calendar.getInstance());
                SMError error = new SMError("General error");
                error.setDescription("General Error");
                error.setResourceId(UUID.randomUUID().toString());
                error.setResourceType(SMResourceType.ERROR.ordinal());
                session.save((Object)error);
                SMAbstractResource ar = new SMAbstractResource();
                ar.setResource((SMResource)error);
                ar.setAbstractResourceId(error.getResourceId());
                session.save((Object)ar);
                smoperation.setAbstractResource(ar);
            }
            if (status == SMOperationStatus.PENDING) {
                smoperation.setSubmissionDate(Calendar.getInstance());
            }
            session.saveOrUpdate((Object)smoperation);
            t.commit();
        }
        catch (Exception e) {
            HibernateManager.roolbackTransaction(t);
        }
        finally {
            HibernateManager.closeSession((org.hibernate.Session)session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setComputationalInfrastructure(long operationId, INFRASTRUCTURE infra) {
        Session session = HibernateManager.getSessionFactory().openSession();
        Transaction t = session.beginTransaction();
        try {
            SMComputation smcomputation = (SMComputation)session.get(SMComputation.class, (Serializable)Long.valueOf(operationId));
            smcomputation.setInfrastructure(infra.toString());
            session.save((Object)smcomputation);
            t.commit();
        }
        catch (Exception e) {
            HibernateManager.roolbackTransaction(t);
        }
        finally {
            HibernateManager.closeSession((org.hibernate.Session)session);
        }
    }

    private static void removeResources(org.hibernate.Session session, long operationId) {
        Query query = session.createQuery("select resource from SMResource  resource where resource.operationId = :operationId ");
        query.setParameter("operationId", (Object)operationId);
        List resources = query.list();
        if (resources != null) {
            for (SMResource resource : resources) {
                switch (SMResourceType.values()[resource.getResourceType()]) {
                    case TABULAR: {
                        try {
                            DataBaseManager.removeTable(resource.getResourceId());
                        }
                        catch (Exception e) {
                            logger.error((Object)"Table no deleted", (Throwable)e);
                        }
                        break;
                    }
                    case FILE: {
                        break;
                    }
                    case OBJECT: {
                        break;
                    }
                }
                session.delete((Object)resource);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeComputation(long operationId) {
        Session session = HibernateManager.getSessionFactory().openSession();
        Transaction t = session.beginTransaction();
        try {
            SMComputation smoperation = (SMComputation)session.get(SMComputation.class, (Serializable)Long.valueOf(operationId));
            SMPersistenceManager.removeResources((org.hibernate.Session)session, operationId);
            if (smoperation != null) {
                session.delete((Object)smoperation);
            }
            t.commit();
        }
        catch (Exception e) {
            logger.error((Object)"Computation not removed ", (Throwable)e);
            HibernateManager.roolbackTransaction(t);
        }
        finally {
            HibernateManager.closeSession((org.hibernate.Session)session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeResource(String resourceId) {
        Session session = HibernateManager.getSessionFactory().openSession();
        Transaction t = session.beginTransaction();
        try {
            SMResource resource = (SMResource)session.get(SMResource.class, (Serializable)((Object)resourceId));
            if (resource != null) {
                SMOperation operation = (SMOperation)session.get(SMOperation.class, (Serializable)Long.valueOf(resource.getOperationId()));
                if (operation != null) {
                    session.delete((Object)operation);
                }
                SMPersistenceManager.removeResources((org.hibernate.Session)session, resource.getOperationId());
            }
            t.commit();
        }
        catch (Exception e) {
            logger.error((Object)"Computation not removed ", (Throwable)e);
            HibernateManager.roolbackTransaction(t);
        }
        finally {
            HibernateManager.closeSession((org.hibernate.Session)session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeImporter(long importerId) {
        Session session = HibernateManager.getSessionFactory().openSession();
        Transaction t = session.beginTransaction();
        try {
            SMOperation operation = (SMOperation)session.get(SMOperation.class, (Serializable)Long.valueOf(importerId));
            if (operation != null) {
                session.delete((Object)operation);
            }
            t.commit();
        }
        catch (Exception e) {
            logger.error((Object)"Computation not removed ", (Throwable)e);
            HibernateManager.roolbackTransaction(t);
        }
        finally {
            HibernateManager.closeSession((org.hibernate.Session)session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SMFile getFile(String fileId) {
        Session session = HibernateManager.getSessionFactory().openSession();
        try {
            Query query = session.createQuery("select file from SMFile  file where resourceId = :fileId");
            query.setParameter("fileId", (Object)fileId);
            List objects = query.list();
            if (!objects.isEmpty()) {
                SMFile sMFile = (SMFile)objects.get(0);
                return sMFile;
            }
            SMFile sMFile = null;
            return sMFile;
        }
        finally {
            HibernateManager.closeSession((org.hibernate.Session)session);
        }
    }
}

