/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.experimentspace.computation;

import java.io.File;
import java.security.Key;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.common.core.state.GCUBEWSResourceKey;
import org.gcube.common.encryption.StringEncrypter;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.resources.gcore.utils.Group;
import org.gcube.data.analysis.statisticalmanager.SMOperationStatus;
import org.gcube.data.analysis.statisticalmanager.ServiceContext;
import org.gcube.data.analysis.statisticalmanager.experimentspace.AlgorithmCategory;
import org.gcube.data.analysis.statisticalmanager.experimentspace.ComputationFactory;
import org.gcube.data.analysis.statisticalmanager.experimentspace.computation.BuilderComputationOutput;
import org.gcube.data.analysis.statisticalmanager.experimentspace.computation.SMComputationalAgentInitializationException;
import org.gcube.data.analysis.statisticalmanager.experimentspace.computation.SMParametersSettingException;
import org.gcube.data.analysis.statisticalmanager.experimentspace.computation.SMResourcesNotAvailableException;
import org.gcube.data.analysis.statisticalmanager.persistence.DataBaseManager;
import org.gcube.data.analysis.statisticalmanager.persistence.RemoteStorage;
import org.gcube.data.analysis.statisticalmanager.persistence.RuntimeResourceManager;
import org.gcube.data.analysis.statisticalmanager.persistence.SMPersistenceManager;
import org.gcube.data.analysis.statisticalmanager.stubs.SMComputationConfig;
import org.gcube.data.analysis.statisticalmanager.util.ServiceUtil;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.configuration.INFRASTRUCTURE;
import org.gcube.dataanalysis.ecoengine.datatypes.DatabaseType;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.ServiceType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.DatabaseParameters;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.ServiceParameters;
import org.gcube.dataanalysis.ecoengine.interfaces.ComputationalAgent;
import org.gcube.dataanalysis.ecoengine.processing.factories.ClusterersFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.EvaluatorsFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.GeneratorsFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.ModelersFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.TransducerersFactory;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.ComputationalAgentClass;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMComputation;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMFile;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMInputEntry;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMResource;
import org.globus.wsrf.ResourceProperty;

public class ComputationResource
extends GCUBEWSResource {
    private static final String NAME_RP_NAME = "computation";
    private volatile String userLogin;
    private volatile String scope;
    private static ConcurrentHashMap<String, ComputationalAgent> runningCAgents = new ConcurrentHashMap();

    private String getConfigPath() {
        return ServiceContext.getContext().getProperty("configDir", new boolean[0]) + "/cfg/";
    }

    public void cleanResourcesComputational(INFRASTRUCTURE compInf, long computationId) {
        switch (compInf) {
            case LOCAL: {
                ComputationFactory.getFactoryResource().cleanLocalComputation();
                this.logger.debug((Object)"---------- Clean up local resources");
                break;
            }
            case D4SCIENCE: {
                this.logger.debug((Object)"--------- Clen up D4Science resources");
                ComputationFactory.getFactoryResource().cleanD4ScienceComputation();
            }
        }
    }

    private synchronized void addComputationalAgent(String key, ComputationalAgent agent) {
        runningCAgents.put(key, agent);
        ResourceProperty property = this.getResourcePropertySet().get(NAME_RP_NAME);
        property.add((Object)key);
    }

    private synchronized void removeComputationalAgent(String key) {
        runningCAgents.remove(key);
        ResourceProperty property = this.getResourcePropertySet().get(NAME_RP_NAME);
        property.clear();
        for (Map.Entry<String, ComputationalAgent> entry : runningCAgents.entrySet()) {
            property.add((Object)entry.getKey());
        }
    }

    private void setComputationOutput(long computationId, ComputationalAgent agent) throws Exception {
        SMComputation computation = (SMComputation)SMPersistenceManager.getOperation(computationId);
        StatisticalType output = agent.getOutput();
        BuilderComputationOutput builder = new BuilderComputationOutput(this.userLogin, this.scope, computation);
        SMResource resource = builder.serialize(output);
        SMPersistenceManager.addCreatedResource(computationId, resource);
    }

    public void initialise(Object ... args) throws Exception {
        this.logger.debug((Object)"------ initialize Service Resource");
        this.userLogin = (String)args[0];
        this.scope = (String)args[1];
    }

    protected String[] getPropertyNames() {
        return new String[]{NAME_RP_NAME};
    }

    public ConcurrentHashMap<String, ComputationalAgent> getComputationalAgents() {
        return runningCAgents;
    }

    private AlgorithmConfiguration setUserParameters(AlgorithmConfiguration algoConfig, SMComputationConfig requestConfig) throws Exception {
        Map<String, StatisticalType> parameters = this.getMapParameters(requestConfig.getAlgorithm());
        for (SMInputEntry parameter : requestConfig.getParameters().getList()) {
            this.logger.debug((Object)("Set Parameter user key " + parameter.getKey() + " value " + parameter.getValue()));
            String value = parameter.getValue();
            StatisticalType typeParam = parameters.get(parameter.getKey());
            if (typeParam instanceof PrimitiveType && ((PrimitiveType)typeParam).getType() == PrimitiveTypes.FILE) {
                SMFile file = SMPersistenceManager.getFile(parameter.getValue());
                this.logger.debug((Object)("Parameter is a file with id " + parameter.getValue()));
                this.logger.debug((Object)("File with name" + file.getName()));
                RemoteStorage storage = new RemoteStorage(this.userLogin, this.scope);
                File tmpFile = storage.getFile(File.separator + file.getRemoteName());
                this.logger.debug((Object)("----------- File created " + tmpFile.getAbsolutePath()));
                value = tmpFile.getAbsolutePath();
            }
            algoConfig.setParam(parameter.getKey(), value);
        }
        return algoConfig;
    }

    private Map<String, StatisticalType> getMapParameters(String algorithm) throws Exception {
        HashMap<String, StatisticalType> map = new HashMap<String, StatisticalType>();
        List<StatisticalType> list = this.getListParameters(algorithm);
        for (StatisticalType parameter : list) {
            map.put(parameter.getName(), parameter);
        }
        return map;
    }

    public List<StatisticalType> getListParameters(String algorithm) throws Exception {
        switch (AlgorithmCategory.valueOf(ServiceUtil.getAlgorithmCategory(algorithm))) {
            case DISTRIBUTIONS: {
                return GeneratorsFactory.getAlgorithmParameters((String)this.getConfigPath(), (String)algorithm);
            }
            case EVALUATORS: {
                return EvaluatorsFactory.getEvaluatorParameters((String)this.getConfigPath(), (String)algorithm);
            }
            case MODELS: {
                return ModelersFactory.getModelParameters((String)this.getConfigPath(), (String)algorithm);
            }
            case TRANSDUCERS: {
                return TransducerersFactory.getTransducerParameters((String)this.getConfigPath(), (String)algorithm);
            }
            case CLUSTERERS: {
                return ClusterersFactory.getClustererParameters((String)this.getConfigPath(), (String)algorithm);
            }
        }
        throw new Exception();
    }

    private void setServiceParameters(SMComputationConfig computationConfig, AlgorithmConfiguration algoConfig, List<StatisticalType> parameters) throws SMParametersSettingException {
        this.logger.debug((Object)("Parameter retrieved " + parameters.size()));
        String rrEndPoint = null;
        String rrUser = null;
        String rrPassword = null;
        String rrDBName = null;
        String rrDBDriver = null;
        String rrDBDialect = null;
        for (StatisticalType parameter : parameters) {
            DatabaseType dbType;
            if (parameter.getClass() != DatabaseType.class || (dbType = (DatabaseType)parameter).getDatabaseParameter() != DatabaseParameters.REMOTEDATABASERRNAME) continue;
            try {
                Group<ServiceEndpoint.AccessPoint> accessPoints = RuntimeResourceManager.getRRAccessPoint(dbType.getName());
                for (ServiceEndpoint.AccessPoint accessPoint : accessPoints) {
                    rrEndPoint = accessPoint.address();
                    this.logger.debug((Object)("RR EndPoint " + rrEndPoint));
                    rrUser = accessPoint.username();
                    this.logger.debug((Object)("RR User " + rrUser));
                    rrPassword = StringEncrypter.getEncrypter().decrypt(accessPoint.password(), new Key[0]);
                    this.logger.debug((Object)("RR Password " + rrPassword));
                    Map properties = accessPoint.propertyMap();
                    ServiceEndpoint.Property property = (ServiceEndpoint.Property)properties.get("databaseName");
                    rrDBName = property.name();
                    this.logger.debug((Object)("RR DB Name " + rrDBName));
                    rrDBDialect = ((ServiceEndpoint.Property)properties.get("dialect")).name();
                    this.logger.debug((Object)("RR DB Dialect " + rrDBDialect));
                    rrDBDriver = ((ServiceEndpoint.Property)properties.get("driver")).name();
                    this.logger.debug((Object)("RR DB Driver " + rrDBDriver));
                }
            }
            catch (Exception e) {
                this.logger.error((Object)("RR " + dbType.getName() + " NOT FOUND"), (Throwable)e);
            }
        }
        for (StatisticalType parameter : parameters) {
            this.logger.debug((Object)("Parameter retrieved " + parameter.getClass()));
            if (parameter instanceof DatabaseType) {
                switch (((DatabaseType)parameter).getDatabaseParameter()) {
                    case DATABASEURL: {
                        algoConfig.setParam(parameter.getName(), DataBaseManager.getUrlDB());
                        break;
                    }
                    case DATABASEPASSWORD: {
                        algoConfig.setParam(parameter.getName(), DataBaseManager.getPassword());
                        break;
                    }
                    case DATABASEUSERNAME: {
                        algoConfig.setParam(parameter.getName(), DataBaseManager.getUsername());
                        break;
                    }
                    case DATABASEDRIVER: {
                        algoConfig.setParam(parameter.getName(), rrDBDriver != null ? rrDBDriver : DataBaseManager.getDriver());
                        break;
                    }
                    case DATABASEDIALECT: {
                        if (rrDBDialect != null) {
                            algoConfig.setParam(parameter.getName(), rrDBDialect);
                        }
                    }
                    case REMOTEDATABASEURL: {
                        algoConfig.setParam(parameter.getName(), rrEndPoint);
                        break;
                    }
                    case REMOTEDATABASEUSERNAME: {
                        algoConfig.setParam(parameter.getName(), rrUser);
                        break;
                    }
                    case REMOTEDATABASEPASSWORD: {
                        algoConfig.setParam(parameter.getName(), rrPassword);
                        break;
                    }
                }
            }
            if (parameter instanceof ServiceType) {
                if (((ServiceType)parameter).getServiceParameter() == ServiceParameters.RANDOMSTRING) {
                    String id = "ID_" + UUID.randomUUID().toString().replace("-", "_");
                    if (parameter.getDefaultValue() != null) {
                        id = parameter.getDefaultValue() + id;
                    }
                    this.logger.debug((Object)("Param service name:" + parameter.getName() + " value :" + id.toLowerCase()));
                    algoConfig.setParam(parameter.getName(), id.toLowerCase());
                }
                if (((ServiceType)parameter).getServiceParameter() == ServiceParameters.USERNAME) {
                    this.logger.debug((Object)("Param service name:" + parameter.getName() + " value :" + ((GCUBEWSResourceKey)this.getID()).getValue()));
                    algoConfig.setParam(parameter.getName(), ((GCUBEWSResourceKey)this.getID()).getValue());
                }
            }
            if (!(parameter instanceof PrimitiveType) || ((PrimitiveType)parameter).getType() != PrimitiveTypes.CONSTANT) continue;
            algoConfig.setParam(parameter.getName(), parameter.getDefaultValue());
            this.logger.debug((Object)("Param primitive name constant : " + parameter.getName() + " value : " + parameter.getDefaultValue()));
        }
    }

    public void executeComputation(SMComputationConfig computationConfig, long computationId) throws SMResourcesNotAvailableException {
        AlgorithmConfiguration algoConfig = new AlgorithmConfiguration();
        String algorithm = null;
        try {
            this.logger.debug((Object)" ------------- Computation request: ");
            String configPath = this.getConfigPath();
            algorithm = computationConfig.getAlgorithm();
            this.logger.debug((Object)(" ------------- Algorithm request" + algorithm));
            algoConfig.setConfigPath(configPath);
            algoConfig.setAgent(algorithm);
            algoConfig.setModel(algorithm);
            algoConfig.setPersistencePath(configPath);
            this.logger.debug((Object)"Set user parameters init");
            this.setUserParameters(algoConfig, computationConfig);
            this.logger.debug((Object)"Set service paramter init");
            List<StatisticalType> parameters = this.getListParameters(computationConfig.getAlgorithm());
            this.setServiceParameters(computationConfig, algoConfig, parameters);
        }
        catch (Exception e) {
            this.logger.error((Object)"Set service parameter error in execute computation :", (Throwable)e);
            try {
                SMPersistenceManager.setOperationStatus(computationId, SMOperationStatus.FAILED);
            }
            catch (Exception e1) {
                this.logger.error((Object)"Set status failed error in excute computation set parameters :", (Throwable)e1);
            }
            return;
        }
        try {
            this.logger.debug((Object)"Init computation");
            this.initComputation(computationConfig, algorithm, algoConfig, computationId);
        }
        catch (SMComputationalAgentInitializationException e) {
            this.logger.error((Object)"Init computation failed", (Throwable)e);
            try {
                SMPersistenceManager.setOperationStatus(computationId, SMOperationStatus.FAILED);
            }
            catch (Exception e1) {
                this.logger.error((Object)"Set status failed error in init computation :", (Throwable)e1);
            }
        }
    }

    private void startComputation(final long computationId, final INFRASTRUCTURE infra, final ComputationalAgent agent) throws SMComputationalAgentInitializationException {
        this.addComputationalAgent(String.valueOf(computationId), agent);
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    SMPersistenceManager.setOperationStatus(computationId, SMOperationStatus.RUNNING);
                    agent.init();
                    agent.compute();
                    ComputationResource.this.setComputationOutput(computationId, agent);
                }
                catch (Exception e) {
                    ComputationResource.this.logger.error((Object)"Compute action failed", (Throwable)e);
                    try {
                        SMPersistenceManager.setOperationStatus(computationId, SMOperationStatus.FAILED);
                    }
                    catch (Exception e1) {
                        ComputationResource.this.logger.error((Object)("Error save status FAILED computation " + computationId), (Throwable)e1);
                    }
                }
                finally {
                    ComputationResource.this.cleanResourcesComputational(infra, computationId);
                    ComputationResource.this.removeComputationalAgent(String.valueOf(computationId));
                }
            }
        }.start();
    }

    private List<? extends ComputationalAgent> getComputationalAgentsAvailable(SMComputationConfig computationConfig, AlgorithmConfiguration algoConfig) throws SMComputationalAgentInitializationException {
        ComputationalAgentClass cac = null;
        try {
            cac = ComputationalAgentClass.fromString((String)ServiceUtil.getAlgorithmCategory(computationConfig.getAlgorithm()));
            switch (AlgorithmCategory.valueOf(cac.getValue())) {
                case DISTRIBUTIONS: {
                    return GeneratorsFactory.getGenerators((AlgorithmConfiguration)algoConfig);
                }
                case EVALUATORS: {
                    return EvaluatorsFactory.getEvaluators((AlgorithmConfiguration)algoConfig);
                }
                case CLUSTERERS: {
                    return ClusterersFactory.getClusterers((AlgorithmConfiguration)algoConfig);
                }
                case MODELS: {
                    return ModelersFactory.getModelers((AlgorithmConfiguration)algoConfig);
                }
                case TRANSDUCERS: {
                    return TransducerersFactory.getTransducerers((AlgorithmConfiguration)algoConfig);
                }
            }
            this.logger.error((Object)"Computational agent category not found ");
            throw new Exception();
        }
        catch (Exception e) {
            this.logger.error((Object)"Computational agent list not found", (Throwable)e);
            throw new SMComputationalAgentInitializationException("Algorithm requested filed : " + (cac != null ? cac.getValue() : "computation agent not found"));
        }
    }

    private void initComputation(SMComputationConfig computationConfig, String algorithm, AlgorithmConfiguration algoConfig, long computationId) throws SMComputationalAgentInitializationException, SMResourcesNotAvailableException {
        this.logger.debug((Object)" GET ComputationalAgent List ...");
        algoConfig.setNumberOfResources(Integer.valueOf(1));
        List<? extends ComputationalAgent> agents = this.getComputationalAgentsAvailable(computationConfig, algoConfig);
        this.logger.debug((Object)(" FOUND Generetors List with size ..." + agents));
        for (ComputationalAgent computationalAgent : agents) {
            this.logger.debug((Object)("INFRASTRACTURE for ComputationalAgent found : " + computationalAgent.getInfrastructure().toString()));
            switch (computationalAgent.getInfrastructure()) {
                case D4SCIENCE: {
                    this.logger.debug((Object)"Start D4Science computation");
                    if (!ComputationFactory.getFactoryResource().setD4ScienceComputation()) {
                        this.logger.debug((Object)"D4Science resource not available");
                        break;
                    }
                    try {
                        SMPersistenceManager.setComputationalInfrastructure(computationId, INFRASTRUCTURE.D4SCIENCE);
                        String infra = (String)GHNContext.getContext().getProperty("infrastructure", new boolean[]{true});
                        algoConfig.setGcubeScope("/" + infra);
                        this.logger.debug((Object)"Retrieve ComputationalAgent parameters .... ");
                        List parameters = computationalAgent.getInputParameters();
                        this.setServiceParameters(computationConfig, algoConfig, parameters);
                        computationalAgent.setConfiguration(algoConfig);
                        this.startComputation(computationId, INFRASTRUCTURE.D4SCIENCE, computationalAgent);
                        this.logger.debug((Object)"Computation started in D4Science ... ");
                        return;
                    }
                    catch (Exception e) {
                        this.logger.error((Object)"Start computation failed", (Throwable)e);
                        this.cleanResourcesComputational(INFRASTRUCTURE.D4SCIENCE, computationId);
                        throw new SMComputationalAgentInitializationException("ComputationalAgent initialization failed " + e.getMessage());
                    }
                }
                case LOCAL: {
                    int resources = 0;
                    try {
                        resources = ComputationFactory.getFactoryResource().getLocalResourcesNeeded(computationConfig.getAlgorithm(), ServiceUtil.getAlgorithmCategory(computationConfig.getAlgorithm()));
                        this.logger.debug((Object)("---------> Resources needed :" + resources));
                    }
                    catch (Exception e) {
                        throw new SMComputationalAgentInitializationException("ComputationalAgent initialization failed " + e.getMessage());
                    }
                    boolean free = ComputationFactory.getFactoryResource().getLocalComputation();
                    this.logger.debug((Object)("---------> Resources free   :" + free));
                    if (!free) {
                        throw new SMResourcesNotAvailableException("Local Resources not available");
                    }
                    try {
                        this.logger.debug((Object)"Computation started in LOCAL ...");
                        SMPersistenceManager.setComputationalInfrastructure(computationId, INFRASTRUCTURE.LOCAL);
                        this.logger.debug((Object)"Set number of resources ");
                        algoConfig.setNumberOfResources(Integer.valueOf(resources));
                        computationalAgent.setConfiguration(algoConfig);
                        this.startComputation(computationId, INFRASTRUCTURE.LOCAL, computationalAgent);
                        return;
                    }
                    catch (Exception e) {
                        this.logger.error((Object)"Start computation failed", (Throwable)e);
                        this.cleanResourcesComputational(INFRASTRUCTURE.LOCAL, computationId);
                        throw new SMComputationalAgentInitializationException("ComputationalAgent initialization failed " + e.getMessage());
                    }
                }
            }
        }
        throw new SMComputationalAgentInitializationException("Computation initialization failed");
    }
}

