/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.persistence;

import java.security.Key;
import java.util.List;
import java.util.Map;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.encryption.StringEncrypter;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.resources.gcore.utils.Group;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.analysis.statisticalmanager.ServiceContext;
import org.gcube.data.analysis.statisticalmanager.exception.StatisticalManagerException;
import org.gcube.data.analysis.statisticalmanager.persistence.DataBaseManager;
import org.gcube.data.analysis.statisticalmanager.persistence.HibernateManager;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;

public class RuntimeResourceManager {
    private static GCUBELog logger = new GCUBELog(RuntimeResourceManager.class);
    private static final String RUNTIME_RESOURCE_DB = "StatisticalManagerDataBase";

    public static void initializeDataBase() throws Exception {
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Name/text() eq 'StatisticalManagerDataBase'");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        Map scopes = ServiceContext.getContext().getInstance().getScopes();
        List resources = null;
        for (Map.Entry scope : scopes.entrySet()) {
            ScopeProvider.instance.set(((GCUBEScope)scope.getValue()).toString());
            resources = client.submit((Query)query);
            if (resources == null || resources.isEmpty()) continue;
            break;
        }
        if (resources == null || resources.isEmpty()) {
            throw new StatisticalManagerException("Runtime resource StatisticalManagerDataBase not found");
        }
        ServiceEndpoint resource = (ServiceEndpoint)resources.get(0);
        if (resource.profile().accessPoints() == null || resource.profile().accessPoints().isEmpty()) {
            throw new StatisticalManagerException("Accesspoint in resource StatisticalManagerDataBase not found");
        }
        for (ServiceEndpoint.AccessPoint ap : resource.profile().accessPoints()) {
            logger.debug((Object)("Access point name " + ap.name()));
            if (ap.name().equals("jdbc")) {
                logger.debug((Object)("URL jdbc  " + ap.address()));
                logger.debug((Object)("User jdbc " + ap.username()));
                logger.debug((Object)("Pass jdbc " + StringEncrypter.getEncrypter().decrypt(ap.password(), new Key[0])));
                DataBaseManager.initializeDataSource(ap.address(), ap.username(), StringEncrypter.getEncrypter().decrypt(ap.password(), new Key[0]));
            }
            if (!ap.name().equals("hibernate")) continue;
            logger.debug((Object)("URL hibernate  " + ap.address()));
            logger.debug((Object)("User hibernate " + ap.username()));
            logger.debug((Object)("Pass hibernate " + StringEncrypter.getEncrypter().decrypt(ap.password(), new Key[0])));
            HibernateManager.buildSessionFactory(ap.address(), ap.username(), StringEncrypter.getEncrypter().decrypt(ap.password(), new Key[0]));
        }
    }

    public static Group<ServiceEndpoint.AccessPoint> getRRAccessPoint(String runtimeResource) throws Exception {
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Name/text() eq '" + runtimeResource + "'");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        Map scopes = ServiceContext.getContext().getInstance().getScopes();
        List resources = null;
        for (Map.Entry scope : scopes.entrySet()) {
            ScopeProvider.instance.set(((GCUBEScope)scope.getValue()).toString());
            resources = client.submit((Query)query);
            if (resources == null || resources.isEmpty()) continue;
            break;
        }
        if (resources == null || resources.isEmpty()) {
            throw new StatisticalManagerException("Runtime resource " + runtimeResource + " not found");
        }
        ServiceEndpoint resource = (ServiceEndpoint)resources.get(0);
        if (resource.profile().accessPoints() == null || resource.profile().accessPoints().isEmpty()) {
            throw new StatisticalManagerException("Accesspoint in resource " + runtimeResource + " not found");
        }
        return resource.profile().accessPoints();
    }
}

