package org.gcube.data.analysis.statisticalmanager.util;

import static org.gcube.resources.discovery.icclient.ICFactory.client;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map.Entry;

import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.homelibrary.home.Home;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.exceptions.HomeNotFoundException;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.exceptions.UserNotFoundException;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.analysis.statisticalmanager.experimentspace.ComputationFactory;
import org.gcube.data.analysis.statisticalmanager.experimentspace.ComputationFactoryResource;
import org.gcube.data.analysis.statisticalmanager.experimentspace.FactoryComputationParameter;
import org.gcube.data.analysis.statisticalmanager.experimentspace.genericresources.GenericRGenerator;
import org.gcube.data.analysis.statisticalmanager.stubs.SMAlgorithm;
import org.gcube.data.analysis.statisticalmanager.stubs.SMGroupedAlgorithms;
import org.gcube.data.analysis.statisticalmanager.stubs.SMListGroupedAlgorithms;
import org.gcube.data.analysis.statisticalmanager.stubs.SMTypeParameter;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.processing.factories.ProcessorsFactory;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.QueryBox;

public class ServiceUtil {

	private static GCUBELog logger = new GCUBELog(ServiceUtil.class);

	private static boolean isGenericResourceInScope(List<String> rtrs,
			String name) {

		if (rtrs.contains(name)) {
			// logger.debug("Algorithm "+name + " IS IN the scope "+
			// ServiceContext.getContext().getScope());
			return true;
		} else {
			// logger.debug("Algorithm "+name + "is NOT in the scope "+
			// ServiceContext.getContext().getScope());
			return false;
		}

	}

	private static List<String> getScpeResources(String scope)
			throws Exception {

		List<String> algNames = new ArrayList<String>();

		String queryString = "for $resource in collection('/db/Profiles/GenericResource')"
				+ "//Resource where ($resource/Profile/SecondaryType eq '"
				+ GenericRGenerator.SECONDARY_TYPE
				+ "')"
				+ " and ($resource/Scopes/Scope eq '"
				+ scope
				+ "') return $resource/Profile/Name/text()";
		logger.debug(queryString);
		Query q = new QueryBox(queryString);

		DiscoveryClient<String> client = client();
		algNames.addAll(client.submit(q));

		int size = algNames.size();
		logger.debug("Size gr found :" + size);
		return algNames;

	}

	public static SMListGroupedAlgorithms getGroupedAlgorithm(
			SMTypeParameter[] param, HashMap<String, List<String>> mapFeatures)
			throws Exception {
		String callScope=ScopeProvider.instance.get();
		List<String> grs = getScpeResources(callScope);
		ArrayList<SMGroupedAlgorithms> features = new ArrayList<SMGroupedAlgorithms>();
		HashMap<SMAlgorithm, List<StatisticalType>> algorithmsForGrUpdate = new HashMap<SMAlgorithm, List<StatisticalType>>();
		for (Entry<String, List<String>> entry : mapFeatures.entrySet()) {

			SMGroupedAlgorithms feature = new SMGroupedAlgorithms();
			feature.setCategory(entry.getKey());

			ArrayList<SMAlgorithm> algorithms = new ArrayList<SMAlgorithm>();

			for (String algorithmName : entry.getValue()) {

				// Retrieve computational agent category
				String algorithmCategory = getAlgorithmCategory(algorithmName);
				logger.debug("Computer category " + algorithmCategory);

				List<StatisticalType> parameters = ComputationFactory
						.getFactoryResource().getListParameters(
								algorithmCategory, algorithmName);

				String description = ComputationFactory.getFactoryResource()
						.getAgorithmDescription(algorithmCategory,
								algorithmName);
				algorithmsForGrUpdate.put(new SMAlgorithm(algorithmCategory,
						description, algorithmName), parameters);
				if (isGenericResourceInScope(grs, algorithmName)) {

					logger.debug("Add algorithm :" + algorithmName);
					if (param == null || (param.length == 0)) {
						algorithms.add(new SMAlgorithm(algorithmCategory,
								description, algorithmName));

					} else {
						for (SMTypeParameter typeParameter : param) {
							if (FactoryComputationParameter.containParameter(
									typeParameter, parameters)) {
								algorithms.add(new SMAlgorithm(
										algorithmCategory, description,
										algorithmName));
							}
						}
					}

				}

			}

			if (!algorithms.isEmpty()) {
				feature.setList(algorithms.toArray(new SMAlgorithm[algorithms
						.size()]));
				features.add(feature);
			}
		}
		logger.debug("Call gr publish ");
		GenericRGenerator gr = new GenericRGenerator();
		gr.publishGRNew(algorithmsForGrUpdate);
		ScopeProvider.instance.set(callScope);
		return new SMListGroupedAlgorithms(
				features.toArray(new SMGroupedAlgorithms[features.size()]));
	}

	public static String getAlgorithmCategory(String algorithmUser)
			throws Exception {

		String configPath = ComputationFactoryResource.getConfigPath();
		HashMap<String, List<String>> mapFeatures = ProcessorsFactory
				.getAllFeatures(configPath);
		for (Entry<String, List<String>> entry : mapFeatures.entrySet()) {
			List<String> algorithms = entry.getValue();
			// logger.debug("Correctly obtained algorithms :");
			for (String algorithm : algorithms) {
				// logger.debug(algorithm);
				if (algorithm.equals(algorithmUser))
					return entry.getKey();
			}

		}

		// logger.error("Computation agent category not found");
		throw new Exception("Computation agent category not found");
	}
public static WorkspaceFolder getWorkspaceSMFolder(String userName) throws WorkspaceFolderNotFoundException, InternalErrorException, HomeNotFoundException, UserNotFoundException
	{
		WorkspaceFolder appfolder= null;
		try{
			logger.debug("get Workspace Application Folder for the user "+ userName);
			Home home = HomeLibrary.getHomeManagerFactory().getHomeManager()
			.getHome(userName);
		
		logger.debug("get home");
		appfolder= home.getDataArea().getApplicationRoot(
				"StatisticalManager");
		logger.debug("foldere created");

		}
		catch (Exception e) {
			logger.debug("Exception");
			StringWriter sw = new StringWriter();
			PrintWriter pw = new PrintWriter(sw);
			e.printStackTrace(pw);
			logger.debug(sw.toString());
			logger.debug(pw.toString());
			logger.debug(e.toString());

			e.printStackTrace();
		
		}
		return appfolder;
	}
	public static String getDateTime()
	{
		Calendar currentDate = Calendar.getInstance(); //Get the current date
		SimpleDateFormat formatter= new SimpleDateFormat("dd MM yyyy HH_mm_ss"); //format it as per your requirement
		String dateNow = formatter.format(currentDate.getTime());
		return dateNow;
	}
	public static Workspace getWorkspace(String user) throws WorkspaceFolderNotFoundException, InternalErrorException, HomeNotFoundException, UserNotFoundException
	{
		return HomeLibrary
				.getHomeManagerFactory()
				.getHomeManager()
				.getHome(user)
				.getWorkspace();
		
	}
	



}
