/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.dataspace.importer;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.lexicalmatcher.analysis.core.DataTypeRecognizer;
import org.gcube.data.analysis.statisticalmanager.dataspace.importer.CSVAbstractLineProcessor;

public class CSVLineProcessorGeneric
extends CSVAbstractLineProcessor {
    private static GCUBELog logger = new GCUBELog(CSVLineProcessorGeneric.class);
    private boolean stop = true;
    private int count = 0;
    private Map<String, List<String>> map;
    int maxIteration = 100;
    ArrayList<String> types;
    public ArrayList<ArrayList<String>> firstColumns = new ArrayList();

    public CSVLineProcessorGeneric(String separator) {
        super(separator);
    }

    public boolean continueProcessing() {
        return this.stop;
    }

    private ArrayList<String> getColumn(int index, ArrayList<ArrayList<String>> values) {
        logger.debug((Object)("Column " + index));
        ArrayList<String> column = new ArrayList<String>();
        for (ArrayList<String> ar : values) {
            if (ar == null || index >= ar.size()) continue;
            column.add(ar.get(index));
        }
        this.printArray(column);
        return column;
    }

    @Override
    public void processDataLine(int arg0, List<String> fields) {
        super.processDataLine(arg0, fields);
        if (this.count >= this.maxIteration) {
            this.stop = false;
        } else {
            if (fields != null) {
                ArrayList<String> ar = new ArrayList<String>(fields);
                this.printArray(ar);
                String fieldValue = ar.get(0);
                List<String> elements = null;
                elements = this.separator.equals(",") ? fields : Arrays.asList(fieldValue.split(this.separator));
                this.printArray(elements);
                int ncolumns = elements.size();
                logger.debug((Object)("number of columns are" + ncolumns));
                for (int i = 0; i < ncolumns; ++i) {
                    logger.debug((Object)("i: " + i));
                    String element = elements.get(i);
                    logger.debug((Object)("element :" + element));
                    logger.debug((Object)("count " + this.count));
                    if (i >= this.firstColumns.size()) {
                        ArrayList<String> newer = new ArrayList<String>();
                        newer.add(element);
                        this.firstColumns.add(newer);
                    } else {
                        this.firstColumns.get(i).add(element);
                    }
                    logger.debug((Object)("in the column " + i + "put element" + element));
                }
            }
            ++this.count;
        }
    }

    private void printArray(List<String> a) {
        for (String ar : a) {
            logger.debug((Object)ar);
            logger.debug((Object)"****");
        }
    }

    private int firstIndexNotNull(ArrayList<ArrayList<String>> ars) {
        int i = 0;
        for (ArrayList<String> ar : ars) {
            if (ar != null) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static String getSqlType(ArrayList<String> values) {
        String className = DataTypeRecognizer.guessType(values);
        String sqlType = null;
        if (String.class.getName().equals(className)) {
            sqlType = "varchar";
        }
        if (Boolean.class.getName().equals(className)) {
            sqlType = "boolean";
        }
        if (BigDecimal.class.getName().equals(className)) {
            sqlType = "double precision";
        }
        return sqlType;
    }

    public static String getSqlType(String value) {
        ArrayList<String> values = new ArrayList<String>();
        values.add(value);
        String className = DataTypeRecognizer.guessType(values);
        logger.debug((Object)("class name for : " + value + " is " + className));
        String sqlType = "varchar";
        if (String.class.getName().equals(className)) {
            sqlType = "varchar";
        }
        if (Boolean.class.getName().equals(className)) {
            sqlType = "boolean";
        }
        if (BigDecimal.class.getName().equals(className)) {
            sqlType = "double precision";
        }
        return sqlType;
    }

    public void addSqlType(ArrayList<String> values) {
        if (values != null) {
            this.sqlTypes.addAll(values);
        }
    }
}

