package org.gcube.data.analysis.statisticalmanager.dataspace.exporter;

import static org.gcube.data.analysis.statisticalmanager.persistence.DataBaseManager.closeConn;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;


import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.analysis.statisticalmanager.exception.StatisticalManagerException;
import org.gcube.data.analysis.statisticalmanager.persistence.DataBaseManager;
import org.postgresql.copy.CopyManager;
import org.postgresql.core.BaseConnection;

public class CSVExporter {

	protected final GCUBELog logger = new GCUBELog(this);	
	private File file;
	private String tableId;
	
	public CSVExporter(String tableId, File file) {
		this.file = file;
		this.tableId = tableId;
	}
	
	public long exporterToFile() throws StatisticalManagerException, FileNotFoundException,
	SQLException, IOException
	 {
		
		Connection conn = null;
		CopyManager copyManager = null;
		try {
			conn = DriverManager.getConnection(DataBaseManager.getUrlDB(),
					DataBaseManager.getUsername(), DataBaseManager.getPassword());
			copyManager = new CopyManager((BaseConnection) conn);
		} catch (SQLException e) {
			closeConn(conn);
			throw new StatisticalManagerException();
		} 
		
		try {
			logger.debug("Try to retrieve resource");
			long result = copyManager.copyOut(String.format("COPY %s TO STDOUT CSV HEADER",
					tableId), new FileOutputStream(file));
			logger.debug("Resource retrieved with successful");
			return result;	
		} finally {
			closeConn(conn);
		}
		
	}
	
}
