package org.gcube.data.analysis.statisticalmanager.experimentspace;

import static org.gcube.data.analysis.statisticalmanager.persistence.HibernateManager.closeSession;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.gcube.common.core.contexts.GCUBEServiceContext.Status;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.scope.GCUBEScope.Type;
import org.gcube.common.core.types.VOID;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.data.access.queueManager.QueueType;
import org.gcube.data.access.queueManager.impl.QueueProducer;
import org.gcube.data.access.queueManager.impl.QueueProducerFactory;
import org.gcube.data.access.queueManager.model.QueueItem;
import org.gcube.data.access.queueManager.model.RequestItem;
import org.gcube.data.analysis.statisticalmanager.SMOperationStatus;
import org.gcube.data.analysis.statisticalmanager.ServiceContext;
import org.gcube.data.analysis.statisticalmanager.exception.StatisticalManagerException;
import org.gcube.data.analysis.statisticalmanager.persistence.HibernateManager;
import org.gcube.data.analysis.statisticalmanager.persistence.SMPersistenceManager;
import org.gcube.data.analysis.statisticalmanager.stubs.ComputationFactoryPortType;
import org.gcube.data.analysis.statisticalmanager.stubs.SMAlgorithm;
import org.gcube.data.analysis.statisticalmanager.stubs.SMAlgorithmsRequest;
import org.gcube.data.analysis.statisticalmanager.stubs.SMComputationConfig;
import org.gcube.data.analysis.statisticalmanager.stubs.SMComputationRequest;
import org.gcube.data.analysis.statisticalmanager.stubs.SMComputations;
import org.gcube.data.analysis.statisticalmanager.stubs.SMComputationsRequest;
import org.gcube.data.analysis.statisticalmanager.stubs.SMGroupedAlgorithms;
import org.gcube.data.analysis.statisticalmanager.stubs.SMListGroupedAlgorithms;
import org.gcube.data.analysis.statisticalmanager.stubs.SMParameter;
import org.gcube.data.analysis.statisticalmanager.stubs.SMParameters;
import org.gcube.data.analysis.statisticalmanager.util.ServiceUtil;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.processing.factories.ProcessorsFactory;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMComputation;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMEntries;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMEntry;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMInputEntry;
import org.hibernate.Query;
import org.hibernate.Session;

public class ComputationFactory extends GCUBEPortType implements
		ComputationFactoryPortType {

	GCUBELog logger = new GCUBELog(ComputationFactory.class);

	private static final String keyFRString = "keyFactoryResource";
	private static ComputationFactoryResource resource;

	/** {@inheritDoc} */
	@Override
	protected ServiceContext getServiceContext() {
		return ServiceContext.getContext();
	}

	public static ComputationFactoryResource getFactoryResource() {
		return resource;
	}

	@Override
	protected void onInitialisation() throws Exception {
		try {
			AnalysisLogger.setLogger(ComputationFactoryResource.getConfigPath()
					+ AlgorithmConfiguration.defaultLoggerFile);
		} catch (Exception ex) {
			logger.debug("------AnalysisLogger setting problems :"
					+ ex.toString());

		} finally {

			if (resource != null)
				return;// cannot create the state twice

			logger.info("Initialising the factory state...");
			new Thread() {

				@Override
				public void run() {
					int attempts = 0;
					boolean created = false;
					while (attempts++ < 10) {
						try {
							Thread.sleep(1000);
						} catch (InterruptedException e1) {
							logger.error("Failed to sleep in between factory creation");
							ServiceContext.getContext()
									.setStatus(Status.FAILED);
							break;
						}
						try {
							for (GCUBEScope scope : ServiceContext.getContext()
									.getInstance().getScopes().values()) {

								logger.debug("Creating the resource within the scope "
										+ scope.getName());
								ServiceContext.getContext().setScope(scope);

							}

							resource = (ComputationFactoryResource) ComputationFactoryContext
									.getContext()
									.getWSHome()
									.create(ComputationFactoryContext
											.getContext().makeKey(keyFRString));

							created = true;
							break;
						} catch (Exception e) {
							logger.error("Failed to create the resource", e);
						}
					}
					if (!created)
						ServiceContext.getContext().setStatus(Status.FAILED);
				}

			}.start();
		}
	}

	@Override
	public SMParameters getAlgorithmParameters(String algorithm)
			throws RemoteException, GCUBEFault {

		List<StatisticalType> parameters = null;
		try {
			parameters = getFactoryResource().getListParameters(
					ServiceUtil.getAlgorithmCategory(algorithm), algorithm);
		} catch (Exception e) {
			throw ServiceContext
					.getContext()
					.getDefaultException(
							"Parameters unknown for this computation", e)
					.toFault();
		}

		logger.debug("------------- parameters retrieved");
		ArrayList<SMParameter> listParameters = new ArrayList<SMParameter>();
		for (StatisticalType param : parameters) {
			SMParameter smParameter = FactoryComputationParameter
					.createParameter(param);
			if (smParameter != null)
				listParameters.add(smParameter);
		}

		return new SMParameters(
				listParameters.toArray(new SMParameter[listParameters.size()]));
	}

	@Override
	public SMListGroupedAlgorithms getAlgorithmsUser(SMAlgorithmsRequest request)
			throws RemoteException, GCUBEFault {

		logger.debug("Called get user perspective");

		try {
			String configPath = ComputationFactoryResource.getConfigPath();

			HashMap<String, List<String>> map = ProcessorsFactory
					.getAllFeaturesUser(setUpBuildWPS(configPath));
			// HashMap<String, List<String>> map = ProcessorsFactory
			// .getAllFeaturesUser(configPath);
			SMListGroupedAlgorithms group = ServiceUtil.getGroupedAlgorithm(
					request.getParameters(), map);

			return group;
			// return ServiceUtil.getGroupedAlgorithm(request.getParameters(),
			// map);
		} catch (Exception e) {
			logger.error("Get features error ", e);
			throw ServiceContext.getContext().getDefaultException(e).toFault();
		}
	}

	@Override
	public SMListGroupedAlgorithms getAlgorithms(SMAlgorithmsRequest request)
			throws RemoteException, GCUBEFault {

		logger.debug("Called get all algorithm");

		try {
			String configPath = ComputationFactoryResource.getConfigPath();
			HashMap<String, List<String>> map = ProcessorsFactory
					.getAllFeatures(setUpBuildWPS(configPath));
			SMListGroupedAlgorithms group = ServiceUtil.getGroupedAlgorithm(
					request.getParameters(), map);

			return group;
			// return ServiceUtil.getGroupedAlgorithm(request.getParameters(),
			// map);
		} catch (Exception e) {
			logger.error("Get features error ", e);
			throw ServiceContext.getContext().getDefaultException(e).toFault();
		}
	}

	@Override
	public SMComputations getComputations(SMComputationsRequest request)
			throws RemoteException, GCUBEFault {

		logger.trace("List computations request by user " + request.getUser());
		try {
			if (request.getParameters() == null) {

				SMComputations computations = SMPersistenceManager
						.getComputations(request.getUser(), null, null);
				return computations;
			}
			ArrayList<SMComputation> computationsList = new ArrayList<SMComputation>();

			String configPath = ComputationFactoryResource.getConfigPath();
			HashMap<String, List<String>> map = ProcessorsFactory
					.getAllFeatures(setUpBuildWPS(configPath));
			for (SMGroupedAlgorithms groupedAlgorithm : ServiceUtil
					.getGroupedAlgorithm(request.getParameters(), map)
					.getList()) {

				for (SMAlgorithm algorithm : groupedAlgorithm.getList()) {
					SMComputations computations = SMPersistenceManager
							.getComputations(request.getUser(),
									algorithm.getName(),
									algorithm.getCategory());

					computationsList.addAll(Arrays.asList(computations
							.getList()));
				}
			}
			return new SMComputations(
					computationsList.toArray(new SMComputation[computationsList
							.size()]));
		} catch (Exception e) {
			logger.error("Get Computations error ", e);
			throw ServiceContext.getContext().getDefaultException(e).toFault();
		}

	}

	@Override
	public String executeComputation(SMComputationRequest requestComputation)
			throws RemoteException, GCUBEFault {

		GCUBEScope scope = ServiceContext.getContext().getScope();
		if (scope.isInfrastructure())
			throw ServiceContext.getContext()
					.getDefaultException(new StatisticalManagerException())
					.toFault();

		return executeComputation(requestComputation, scope, null);
	}

	private String executeComputation(SMComputationRequest requestComputation,
			GCUBEScope scope, String computationId) throws GCUBEFault {
		logger.debug("Send a new user request");
		try {

			String queue = scope.getName();
			if (scope.getType() == Type.VRE)
				queue = scope.getEnclosingScope().getName();

			logger.debug("GET queue " + queue);

			QueueProducerFactory factory = QueueProducerFactory
					.get(ComputationFactoryResource.createQueueConfig(queue));

			@SuppressWarnings("unchecked")
			QueueProducer<QueueItem> producer = factory.getSubmitter(
					ComputationFactoryResource.SERVICE, QueueType.REQUEST);

			String category = ServiceUtil
					.getAlgorithmCategory(requestComputation.getConfig()
							.getAlgorithm());

			if (computationId == null) {
				long id = SMPersistenceManager.addComputation(
						requestComputation, category);
				computationId = String.valueOf(id);
			} else {
				SMPersistenceManager.setOperationStatus(
						Long.parseLong(computationId),
						SMOperationStatus.PENDING);
			}

			Map<String, Serializable> parameters = new HashMap<String, Serializable>();
			parameters.put(ComputationFactoryResource.MESSAGE_REQUEST,
					requestComputation);
			parameters.put(ComputationFactoryResource.MESSAGE_COMPUTATION_ID,
					computationId);
			parameters.put(ComputationFactoryResource.MESSAGE_SCOPE,
					ServiceContext.getContext().getScope().toString());
			producer.send(new RequestItem("CallScript", null, parameters));

			return String.valueOf(computationId);

		} catch (Exception e) {
			logger.error("Message sent with exception ", e);
			throw ServiceContext.getContext().getDefaultException(e).toFault();
		}
	}

	@Override
	public SMComputation getComputation(String computationId)
			throws RemoteException, GCUBEFault {

		Session session = HibernateManager.getSessionFactory().openSession();
		try {
			Query query = session
					.createQuery("select computation from SMComputation computation "
							+ "where computation.operationId = :name");

			query.setParameter("name", Long.valueOf(computationId));

			@SuppressWarnings("unchecked")
			List<Object> objects = query.list();

			SMComputation computation = (SMComputation) objects.get(0);

			Query queryParameters = session
					.createQuery("select parameter from SMEntry parameter "
							+ "where parameter.computationId = :operationId");
			queryParameters.setParameter("operationId",
					computation.getOperationId());

			@SuppressWarnings("unchecked")
			List<Object> parameters = queryParameters.list();
			computation.setParameters(parameters.toArray(new SMEntry[parameters
					.size()]));

			return (SMComputation) objects.get(0);

		} finally {
			session.close();
		}
	}

	@Override
	public VOID removeComputation(String computationId) throws RemoteException,
			GCUBEFault {

		logger.debug("Remove computation" + computationId + " from factory");
		// //add modify
		// try {
		//
		// Map<String, ComputationalAgent> agents = ((ComputationResource)
		// ComputationContext.getContext().getWSHome().find()).getComputationalAgents();
		// ComputationalAgent agent = agents.get(computationId);
		// // ComputationResource compRes = (ComputationResource)
		// ComputationContext
		// // .getContext().getWSHome().find();
		// // logger.debug("Resource is found");
		// // ComputationalAgent agent = compRes.getComputationalAgents().get(
		// // computationId);
		// // logger.debug("Agent is found");
		// if (agent != null) {
		// logger.debug("Agent is different from null");
		// agent.shutdown();}
		//
		// } catch (Exception e) {
		// StringWriter sw = new StringWriter();
		// PrintWriter pw = new PrintWriter(sw);
		// e.printStackTrace(pw);
		// logger.debug("Error shutdown : " + sw.toString());
		//
		// }
		// // end add
		// finally{
		SMPersistenceManager.removeComputation(Long.parseLong(computationId));
		// }
		return new VOID();
	}

	@Override
	public String resubmitComputation(String computationId)
			throws RemoteException, GCUBEFault {

		GCUBEScope scope = ServiceContext.getContext().getScope();
		if (scope.isInfrastructure())
			throw ServiceContext.getContext()
					.getDefaultException(new StatisticalManagerException())
					.toFault();

		try {
			SMComputation computation = (SMComputation) SMPersistenceManager
					.getOperation(Long.parseLong(computationId));
			List<SMEntry> parameters = new ArrayList<SMEntry>();

			Session session = HibernateManager.getSessionFactory()
					.openSession();
			try {
				Query queryParameters = session
						.createQuery("select parameter from SMEntry parameter "
								+ "where parameter.computationId = :computationId");
				queryParameters.setParameter("computationId",
						computation.getOperationId());

				parameters.addAll(queryParameters.list());

			} finally {
				closeSession(session);
			}

			List<SMInputEntry> entries = new ArrayList<SMInputEntry>();
			for (SMEntry parameter : parameters) {
				entries.add(new SMInputEntry(parameter.getKey(), parameter
						.getValue()));
			}
			SMEntries inputEntries = new SMEntries(
					entries.toArray(new SMInputEntry[entries.size()]));
			SMComputationConfig computationConfig = new SMComputationConfig(
					computation.getAlgorithm(), inputEntries);
			SMComputationRequest request = new SMComputationRequest(
					computationConfig, null, null, computation.getPortalLogin());

			executeComputation(request, scope, computationId);

			return computationId;

		} catch (Exception e) {
			throw ServiceContext.getContext().getDefaultException(e).toFault();
		}
	}

	public static AlgorithmConfiguration setUpBuildWPS(String configPath) {
		AlgorithmConfiguration algoConfig = new AlgorithmConfiguration();

		algoConfig.setConfigPath(configPath);
		algoConfig.setPersistencePath(configPath);
		for (GCUBEScope scope : ServiceContext.getContext().getInstance()
				.getScopes().values()) {

			if (scope.getType() == Type.VO)
				algoConfig.setGcubeScope(scope.toString());

		}
		return algoConfig;
	}

}
