/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.dataspace.exporter;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.analysis.statisticalmanager.exception.StatisticalManagerException;
import org.gcube.data.analysis.statisticalmanager.persistence.DataBaseManager;
import org.postgresql.copy.CopyManager;
import org.postgresql.core.BaseConnection;

public class CSVExporter {
    protected final GCUBELog logger = new GCUBELog((Object)this);
    private File file;
    private String tableId;

    public CSVExporter(String tableId, File file) {
        this.file = file;
        this.tableId = tableId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long exporterToFile() throws StatisticalManagerException, FileNotFoundException, SQLException, IOException {
        Connection conn = null;
        CopyManager copyManager = null;
        try {
            conn = DriverManager.getConnection(DataBaseManager.getUrlDB(), DataBaseManager.getUsername(), DataBaseManager.getPassword());
            copyManager = new CopyManager((BaseConnection)conn);
        }
        catch (SQLException e) {
            DataBaseManager.closeConn(conn);
            throw new StatisticalManagerException();
        }
        try {
            this.logger.debug((Object)"Try to retrieve resource");
            this.logger.debug((Object)"call copy");
            long result = copyManager.copyOut(String.format("COPY %s TO STDOUT CSV HEADER FORCE QUOTE * ESCAPE '\\'", this.tableId), (OutputStream)new FileOutputStream(this.file));
            this.logger.debug((Object)"Resource retrieved with successful");
            long l = result;
            return l;
        }
        finally {
            DataBaseManager.closeConn(conn);
        }
    }
}

