/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.dataspace.importer;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.graphtools.utils.DateGuesser;
import org.gcube.contentmanagement.lexicalmatcher.analysis.core.DataTypeRecognizer;
import org.gcube.data.analysis.statisticalmanager.dataspace.importer.CSVAbstractLineProcessor;

public class CSVLineProcessorTimeSeries
extends CSVAbstractLineProcessor {
    private int indexTime = -1;
    private boolean toContinue = true;
    public ArrayList<ArrayList<String>> firstColumns = new ArrayList();
    private boolean stop = true;
    private int count = 0;
    private File file = File.createTempFile("TimeSeries", "csv");
    int maxIteration = 10;
    private static GCUBELog logger = new GCUBELog(CSVLineProcessorTimeSeries.class);
    ArrayList<String> types;

    public CSVLineProcessorTimeSeries(String separator) throws IOException {
        super(separator);
    }

    public boolean continueProcessing() {
        return this.toContinue;
    }

    private int getIndexTime() {
        if (this.indexTime != -1) {
            return this.indexTime;
        }
        int i = 0;
        for (String value : this.getColsName()) {
            logger.debug((Object)("field " + value));
            if (value.toLowerCase().equals("time")) {
                this.indexTime = i;
            }
            ++i;
        }
        return this.indexTime;
    }

    @Override
    public void processDataLine(int arg0, List<String> fields) {
        super.processDataLine(arg0, fields);
        if (this.count >= this.maxIteration) {
            this.stop = false;
        } else {
            if (fields != null) {
                ArrayList<String> ar = new ArrayList<String>(fields);
                String fieldValue = ar.get(0);
                List<String> elements = null;
                elements = this.separator.equals(",") ? fields : Arrays.asList(fieldValue.split(this.separator));
                int ncolumns = elements.size();
                logger.debug((Object)("number of columns are" + ncolumns));
                for (int i = 0; i < ncolumns; ++i) {
                    logger.debug((Object)("i: " + i));
                    String element = elements.get(i);
                    logger.debug((Object)("element :" + element));
                    logger.debug((Object)("count " + this.count));
                    if (i >= this.firstColumns.size()) {
                        ArrayList<String> newer = new ArrayList<String>();
                        newer.add(element);
                        this.firstColumns.add(newer);
                    } else {
                        this.firstColumns.get(i).add(element);
                    }
                    logger.debug((Object)("in the column " + i + "put element" + element));
                }
            }
            ++this.count;
        }
    }

    private void printArray(List<String> a) {
        for (String ar : a) {
            logger.debug((Object)ar);
            logger.debug((Object)"****");
        }
    }

    public void getWellFormaFile(File f, int indexTime) throws IOException {
        FileWriter fstream = new FileWriter(this.file, true);
        BufferedWriter out = new BufferedWriter(fstream);
        FileReader read = new FileReader(f);
        BufferedReader bufferReader = new BufferedReader(read);
        String row = bufferReader.readLine();
        String formatedRow = this.formatRowWithText(row, this.separator);
        while (formatedRow != null) {
            String[] fields = formatedRow.split(this.separator);
            for (int i = 0; i < fields.length; ++i) {
                String cleanedValue;
                String fieldValue = fields[i];
                if (i == this.getIndexTime()) {
                    cleanedValue = fieldValue.contains("\"") ? fieldValue.replaceAll("\"", "") : fieldValue;
                    Calendar calendar = DateGuesser.convertDate((String)cleanedValue);
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                    String timeValue = new String();
                    if (calendar != null) {
                        timeValue = sdf.format(calendar.getTime());
                        timeValue = i == fields.length - 1 ? timeValue : timeValue + this.separator;
                    } else {
                        timeValue = "" + this.separator;
                    }
                    logger.debug((Object)("timevalue :" + timeValue));
                    out.write(timeValue);
                    continue;
                }
                cleanedValue = fieldValue.contains(",") ? "\"" + fieldValue + "\"" : fieldValue;
                logger.debug((Object)("first clean: " + cleanedValue));
                cleanedValue = i == fields.length - 1 ? cleanedValue : cleanedValue + this.separator;
                logger.debug((Object)cleanedValue);
                out.write(cleanedValue);
            }
            out.write("\n");
            row = bufferReader.readLine();
            if (row != null) {
                formatedRow = this.formatRowWithText(row, this.separator);
                continue;
            }
            formatedRow = null;
        }
        out.close();
    }

    public static String getSqlType(ArrayList<String> values) {
        String className = DataTypeRecognizer.guessType(values);
        String sqlType = null;
        if (String.class.getName().equals(className)) {
            sqlType = "varchar";
        }
        if (Boolean.class.getName().equals(className)) {
            sqlType = "boolean";
        }
        if (BigDecimal.class.getName().equals(className)) {
            sqlType = "double precision";
        }
        return sqlType;
    }

    private String getSQLType(String value) {
        String sqlType = null;
        ArrayList<String> values = new ArrayList<String>();
        values.add(value);
        String className = DataTypeRecognizer.guessType(values);
        if (String.class.getName().equals(className)) {
            sqlType = "varchar";
        }
        if (Boolean.class.getName().equals(className)) {
            sqlType = "boolean";
        }
        if (BigDecimal.class.getName().equals(className)) {
            sqlType = "double precision";
        }
        return sqlType;
    }

    public boolean isTimeFound() {
        return this.indexTime != -1;
    }

    public File getFile() {
        return this.file;
    }

    public String formatRowWithText(String row, String separator) {
        int indexFrom = 0;
        int indexChar = 0;
        int pair = 0;
        String result = new String();
        int i = 0;
        int lastPositiveIndex = 0;
        while (indexChar >= 0) {
            indexChar = i == 0 ? (row.toCharArray()[0] == '\"' ? 0 : row.indexOf("\"", indexFrom + 1)) : row.indexOf("\"", indexFrom + 1);
            if (indexChar >= 0) {
                if (++pair % 2 == 0) {
                    String sub = row.substring(indexFrom, indexChar);
                    if (sub.contains(separator)) {
                        if (separator == ",") {
                            sub = sub.replace(";", " ");
                            sub = sub.replace(separator, ";");
                        } else {
                            sub = sub.replace(",", " ");
                            sub = sub.replaceAll(separator, ",");
                        }
                    }
                    result = result + sub;
                } else {
                    result = result + row.substring(indexFrom, indexChar);
                }
                lastPositiveIndex = indexChar;
            } else if (i == 0) {
                return row;
            }
            indexFrom = indexChar;
            ++i;
        }
        result = result + row.substring(lastPositiveIndex, row.length());
        return result;
    }
}

