/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.persistence;

import java.security.Key;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.encryption.StringEncrypter;
import org.gcube.common.resources.gcore.ScopeGroup;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.resources.gcore.common.Platform;
import org.gcube.common.resources.gcore.utils.Group;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.analysis.statisticalmanager.ServiceContext;
import org.gcube.data.analysis.statisticalmanager.exception.StatisticalManagerException;
import org.gcube.data.analysis.statisticalmanager.persistence.DataBaseManager;
import org.gcube.data.analysis.statisticalmanager.persistence.HibernateManager;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;

public class RuntimeResourceManager {
    private static GCUBELog logger = new GCUBELog(RuntimeResourceManager.class);
    private static final String RUNTIME_RESOURCE_DB = "StatisticalManagerDataBase";

    public static void initializeDataBase() throws Exception {
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Name/text() eq 'StatisticalManagerDataBase'");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        Map scopes = ServiceContext.getContext().getInstance().getScopes();
        List resources = null;
        for (Map.Entry scope : scopes.entrySet()) {
            ScopeProvider.instance.set(((GCUBEScope)scope.getValue()).toString());
            resources = client.submit((Query)query);
            if (resources == null || resources.isEmpty()) continue;
            break;
        }
        if (resources == null || resources.isEmpty()) {
            throw new StatisticalManagerException("Runtime resource StatisticalManagerDataBase not found");
        }
        ServiceEndpoint resource = (ServiceEndpoint)resources.get(0);
        if (resource.profile().accessPoints() == null || resource.profile().accessPoints().isEmpty()) {
            throw new StatisticalManagerException("Accesspoint in resource StatisticalManagerDataBase not found");
        }
        for (ServiceEndpoint.AccessPoint ap : resource.profile().accessPoints()) {
            logger.debug((Object)("Access point name " + ap.name()));
            if (ap.name().equals("jdbc")) {
                logger.debug((Object)("URL jdbc  " + ap.address()));
                logger.debug((Object)("User jdbc " + ap.username()));
                logger.debug((Object)("Pass jdbc " + StringEncrypter.getEncrypter().decrypt(ap.password(), new Key[0])));
                DataBaseManager.initializeDataSource(ap.address(), ap.username(), StringEncrypter.getEncrypter().decrypt(ap.password(), new Key[0]));
            }
            if (!ap.name().equals("hibernate")) continue;
            logger.debug((Object)("URL hibernate  " + ap.address()));
            logger.debug((Object)("User hibernate " + ap.username()));
            logger.debug((Object)("Pass hibernate " + StringEncrypter.getEncrypter().decrypt(ap.password(), new Key[0])));
            HibernateManager.buildSessionFactory(ap.address(), ap.username(), StringEncrypter.getEncrypter().decrypt(ap.password(), new Key[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap<String, String> getRRProfile(String runtimeResource) throws Exception {
        logger.debug((Object)("Looking for RR profile " + runtimeResource));
        String callerScope = ScopeProvider.instance.get();
        try {
            HashMap<String, String> rrParameter = new HashMap<String, String>();
            XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
            query.addCondition("$resource/Profile/Name/text() eq '" + runtimeResource + "'");
            DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
            Map scopes = ServiceContext.getContext().getInstance().getScopes();
            List resources = null;
            logger.debug((Object)("Gonna crawl throug scopes " + scopes.keySet()));
            for (Map.Entry scope : scopes.entrySet()) {
                ScopeProvider.instance.set(((GCUBEScope)scope.getValue()).toString());
                resources = client.submit((Query)query);
                if (resources == null || resources.isEmpty()) continue;
                break;
            }
            logger.debug((Object)("Final scope is " + ScopeProvider.instance.get()));
            if (resources == null || resources.isEmpty()) {
                throw new StatisticalManagerException("Runtime resource " + runtimeResource + " not found");
            }
            ServiceEndpoint resource = (ServiceEndpoint)resources.get(0);
            ScopeGroup scopeGroup = resource.scopes();
            String sc = new String();
            for (String scope : scopeGroup) {
                sc = sc + scope + ";";
            }
            rrParameter.put(runtimeResource + "." + "Scopes", sc);
            ServiceEndpoint.Profile profile = resource.profile();
            rrParameter.put(runtimeResource + "." + "Profile.Category", profile.category());
            Platform platform = profile.platform();
            rrParameter.put(runtimeResource + "." + "Profile.Platform.name", platform.name());
            rrParameter.put(runtimeResource + "." + "Profile.Platform.version", Integer.toString(platform.version()));
            rrParameter.put(runtimeResource + "." + "Profile.Platform.minorVersion", Integer.toString(platform.minorVersion().shortValue()));
            rrParameter.put(runtimeResource + "." + "Profile.Platform.revisionVersion", Integer.toString(platform.revisionVersion().shortValue()));
            rrParameter.put(runtimeResource + "." + "Profile.Platform.buildVersion", Integer.toString(platform.buildVersion().shortValue()));
            ServiceEndpoint.Runtime runtime = profile.runtime();
            rrParameter.put(runtimeResource + "." + "Profile.Runtime.hostedOn", runtime.hostedOn());
            rrParameter.put(runtimeResource + "." + "Profile.Runtime.status", runtime.status());
            rrParameter.put(runtimeResource + "." + "Profile.Runtime.ghnId", runtime.ghnId());
            if (profile.accessPoints() != null) {
                Group accessPoints = profile.accessPoints();
                Iterator i$ = accessPoints.iterator();
                if (i$.hasNext()) {
                    ServiceEndpoint.AccessPoint accessPoint = (ServiceEndpoint.AccessPoint)i$.next();
                    rrParameter.put(runtimeResource + "." + "AccessPoint.Description", accessPoint.description());
                    rrParameter.put(runtimeResource + "." + "AccessPoint.Address", accessPoint.address());
                    rrParameter.put(runtimeResource + "." + "AccessPoint.Password", StringEncrypter.getEncrypter().decrypt(accessPoint.password(), new Key[0]));
                    rrParameter.put(runtimeResource + "." + "AccessPoint.Username", accessPoint.username());
                    Map properties = accessPoint.propertyMap();
                    for (Map.Entry entry : properties.entrySet()) {
                        String propertyName = runtimeResource + "." + ((String)entry.getKey()).toString();
                        String propertyVal = ((ServiceEndpoint.Property)entry.getValue()).toString();
                        logger.debug((Object)("property:" + propertyName + ";" + propertyVal));
                        rrParameter.put(propertyName, propertyVal);
                    }
                }
            } else {
                logger.debug((Object)"access point null");
            }
            HashMap<String, String> hashMap = rrParameter;
            return hashMap;
        }
        finally {
            logger.debug((Object)("Restoring caller scope " + callerScope));
            ScopeProvider.instance.set(callerScope);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Group<ServiceEndpoint.AccessPoint> getRRAccessPoint(String runtimeResource) throws Exception {
        logger.debug((Object)("Looking for RR " + runtimeResource));
        String callerScope = ScopeProvider.instance.get();
        try {
            XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
            query.addCondition("$resource/Profile/Name/text() eq '" + runtimeResource + "'");
            DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
            Map scopes = ServiceContext.getContext().getInstance().getScopes();
            List resources = null;
            logger.debug((Object)("Gonna crawl through scopes " + scopes.keySet()));
            for (Map.Entry scope : scopes.entrySet()) {
                ScopeProvider.instance.set(((GCUBEScope)scope.getValue()).toString());
                resources = client.submit((Query)query);
                if (resources == null || resources.isEmpty()) continue;
                break;
            }
            logger.debug((Object)("Final scope is " + ScopeProvider.instance.get()));
            if (resources == null || resources.isEmpty()) {
                throw new StatisticalManagerException("Runtime resource " + runtimeResource + " not found");
            }
            ServiceEndpoint resource = (ServiceEndpoint)resources.get(0);
            if (resource.profile().accessPoints() == null || resource.profile().accessPoints().isEmpty()) {
                throw new StatisticalManagerException("Accesspoint in resource " + runtimeResource + " not found");
            }
            Group group = resource.profile().accessPoints();
            return group;
        }
        finally {
            logger.debug((Object)("Restoring caller scope " + callerScope));
            ScopeProvider.instance.set(callerScope);
        }
    }
}

