/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.experimentspace;

import javax.jms.JMSException;
import org.gcube.common.core.contexts.GCUBEStatefulPortTypeContext;
import org.gcube.common.core.state.GCUBEWSResourceKey;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.access.queueManager.QueueItemHandler;
import org.gcube.data.access.queueManager.QueueType;
import org.gcube.data.access.queueManager.impl.QueueConsumerFactory;
import org.gcube.data.access.queueManager.model.RequestItem;
import org.gcube.data.analysis.statisticalmanager.Configuration;
import org.gcube.data.analysis.statisticalmanager.experimentspace.computation.ComputationContext;
import org.gcube.data.analysis.statisticalmanager.experimentspace.computation.ComputationResource;
import org.gcube.data.analysis.statisticalmanager.experimentspace.computation.SMResourcesNotAvailableException;
import org.gcube.data.analysis.statisticalmanager.stubs.SMComputationRequest;
import org.gcube.data.analysis.statisticalmanager.util.ServiceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceQueueConsumer
implements QueueItemHandler<RequestItem> {
    private static Logger logger = LoggerFactory.getLogger(ServiceQueueConsumer.class);
    private static int consumerCount = 0;
    private static int receivedCount = 0;
    private static int errorCount = 0;
    private static int servedCount = 0;
    private QueueConsumerFactory consumerFactory;

    public static ConsumerReport getReport() {
        return new ConsumerReport(receivedCount, errorCount, servedCount, consumerCount);
    }

    public ServiceQueueConsumer(QueueConsumerFactory consumerFactory) {
        logger.debug("Created consumer N\u00b0 " + consumerCount++);
        this.consumerFactory = consumerFactory;
    }

    public void handleQueueItem(RequestItem item) throws Exception {
        try {
            logger.debug("Message received" + item.getId());
            ++receivedCount;
            SMComputationRequest request = (SMComputationRequest)item.getParameters().get(Configuration.getProperty(Configuration.JMS_MESSAGE_REQUEST));
            String computationId = (String)item.getParameters().get(Configuration.getProperty(Configuration.JMS_MESSAGE_COMPUTATION_ID));
            logger.debug("ComputationId " + computationId);
            GCUBEStatefulPortTypeContext stfctx = ComputationContext.getContext();
            logger.debug("User" + request.getUser());
            GCUBEWSResourceKey key = stfctx.makeKey(request.getUser());
            String scope = (String)item.getParameters().get(Configuration.getProperty(Configuration.JMS_MESSAGE_SCOPE));
            logger.debug("**************************Scope " + scope);
            ScopeProvider.instance.set(scope);
            ComputationResource wsResource = (ComputationResource)ComputationContext.getContext().getWSHome().create(key, new Object[]{request.getUser(), scope});
            logger.debug("Resource created");
            wsResource.executeComputation(request.getConfig(), Long.parseLong(computationId));
            ++servedCount;
        }
        catch (SMResourcesNotAvailableException e) {
            ++errorCount;
            logger.debug(e.getMessage());
            throw e;
        }
        catch (Exception e) {
            ++errorCount;
            logger.warn("Exception handling Item " + item.getId(), (Throwable)e);
            throw e;
        }
    }

    public void close() {
    }

    private void retryToConnect() {
        try {
            this.consumerFactory.close();
            this.consumerFactory.register(Configuration.getProperty(Configuration.JMS_TOPIC), QueueType.REQUEST, (QueueItemHandler)this);
        }
        catch (JMSException e) {
            logger.error("Consumer connection exception ....retry to connect", (Throwable)e);
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e1) {
                logger.error("Consumer wait time to connect error", (Throwable)e);
            }
            this.retryToConnect();
        }
    }

    public void onException(JMSException arg0) {
        logger.debug("Consumer connection exception ....retry to connect", (Throwable)arg0);
        this.retryToConnect();
    }

    public static class ConsumerReport {
        private long receivedCount = 0L;
        private long errorCount = 0L;
        private long servedCount = 0L;
        private int consumerCount = 0;
        private String reportTime = ServiceUtil.getDateTime();

        private ConsumerReport(long receivedCount, long errorCount, long servedCount, int consumerCount) {
            this.receivedCount = receivedCount;
            this.errorCount = errorCount;
            this.servedCount = servedCount;
            this.consumerCount = consumerCount;
        }

        public long getReceivedCount() {
            return this.receivedCount;
        }

        public long getErrorCount() {
            return this.errorCount;
        }

        public long getServedCount() {
            return this.servedCount;
        }

        public int getConsumerCount() {
            return this.consumerCount;
        }

        public String getReportTime() {
            return this.reportTime;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("consumerReport [receivedCount=");
            builder.append(this.receivedCount);
            builder.append(", errorCount=");
            builder.append(this.errorCount);
            builder.append(", servedCount=");
            builder.append(this.servedCount);
            builder.append(", consumerCount=");
            builder.append(this.consumerCount);
            builder.append(", reportTime=");
            builder.append(this.reportTime);
            builder.append("]");
            return builder.toString();
        }
    }
}

