/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.dataspace.importer;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.gcube.contentmanagement.lexicalmatcher.analysis.core.DataTypeRecognizer;
import org.gcube.data.analysis.statisticalmanager.dataspace.importer.CSVAbstractLineProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVLineProcessorGeneric
extends CSVAbstractLineProcessor {
    private static Logger logger = LoggerFactory.getLogger(CSVLineProcessorGeneric.class);
    private boolean stop = true;
    private int count = 0;
    int maxIteration = 100;
    ArrayList<String> types;
    public ArrayList<ArrayList<String>> firstColumns = new ArrayList();

    public CSVLineProcessorGeneric(String separator) {
        super(separator);
    }

    public boolean continueProcessing() {
        return this.stop;
    }

    @Override
    public void processDataLine(int arg0, List<String> fields) {
        super.processDataLine(arg0, fields);
        if (this.count >= this.maxIteration) {
            this.stop = false;
        } else {
            if (fields != null) {
                ArrayList<String> ar = new ArrayList<String>(fields);
                String fieldValue = ar.get(0);
                List<String> elements = null;
                elements = this.separator.equals(",") ? fields : Arrays.asList(fieldValue.split(this.separator));
                int ncolumns = elements.size();
                for (int i = 0; i < ncolumns; ++i) {
                    String element = elements.get(i);
                    if (i >= this.firstColumns.size()) {
                        ArrayList<String> newer = new ArrayList<String>();
                        newer.add(element);
                        this.firstColumns.add(newer);
                        continue;
                    }
                    this.firstColumns.get(i).add(element);
                }
            }
            ++this.count;
        }
    }

    public static String getSqlType(ArrayList<String> values) {
        String className = DataTypeRecognizer.guessType(values);
        String sqlType = null;
        if (String.class.getName().equals(className)) {
            sqlType = "varchar";
        }
        if (Boolean.class.getName().equals(className)) {
            sqlType = "boolean";
        }
        if (BigDecimal.class.getName().equals(className)) {
            sqlType = "double precision";
        }
        return sqlType;
    }

    public static String getSqlType(String value) {
        ArrayList<String> values = new ArrayList<String>();
        values.add(value);
        String className = DataTypeRecognizer.guessType(values);
        String sqlType = "varchar";
        if (String.class.getName().equals(className)) {
            sqlType = "varchar";
        }
        if (Boolean.class.getName().equals(className)) {
            sqlType = "boolean";
        }
        if (BigDecimal.class.getName().equals(className)) {
            sqlType = "double precision";
        }
        return sqlType;
    }
}

