package org.gcube.data.analysis.tabulardata.cube.data.connection;

import java.sql.Connection;
import java.sql.SQLException;

import org.apache.tomcat.jdbc.pool.DataSource;
import org.apache.tomcat.jdbc.pool.PoolProperties;
import org.gcube.common.database.endpoint.DatabaseEndpoint;
import org.postgresql.PGConnection;

public class Tomcat7DatabaseConnectionProvider implements DatabaseConnectionProvider {
	
	private final static String DRIVER = "org.postgresql.Driver";
	
	private DatabaseEndpoint databaseEndpoint;

	private DataSource dataSource;

	public Tomcat7DatabaseConnectionProvider(DatabaseEndpoint databaseEndpoint) {
		this.databaseEndpoint = databaseEndpoint;
		initializeDatasource();
	}
	
	private void initializeDatasource(){
		PoolProperties poolConfiguration = buildPoolConfiguration();
        dataSource = new DataSource();
        dataSource.setPoolProperties(poolConfiguration);
	}
	
	private PoolProperties buildPoolConfiguration(){
		PoolProperties poolProperties = new PoolProperties();
        poolProperties.setUrl(getConnectionString());
        poolProperties.setDriverClassName(DRIVER);
        poolProperties.setUsername(getDBUsername());
        poolProperties.setPassword(getDBPassword());
        return poolProperties;
	}

	@Override
	public Connection getConnection() throws SQLException {
		return dataSource.getConnection();
	}
	
	@Override
	public PGConnection getPostgreSQLConnection() throws SQLException {
		return dataSource.getConnection().unwrap(PGConnection.class);
	}
	
	@Override
	public DatabaseEndpoint getDatabaseEndpoint(){
		return databaseEndpoint;
	}
	
	private String getConnectionString(){
		return databaseEndpoint.getConnectionString();
	}
	
	private String getDBUsername(){
		return databaseEndpoint.getCredentials().getUsername();
	}
	
	private String getDBPassword(){
		return databaseEndpoint.getCredentials().getPassword();
	}


}
