CREATE OR REPLACE FUNCTION update_day_month_rel() RETURNS trigger as $$
DECLARE
		tmp_day date;
		month integer;
		query text := '';
	BEGIN
		IF is_valid_date(NEW.code) THEN
			NEW.code := normalize_day(NEW.code);
			tmp_day := DATE(NEW.code);
			month := EXTRACT(MONTH FROM tmp_day);
			query := 'WITH ins AS (INSERT INTO month_codelist_table (code, month) VALUES (''' || month || ''', ''' || month|| ''') ) '
				|| 'INSERT INTO day_month_rel VALUES(''' || NEW.code || ''', ''' || month ''')';
			EXECUTE(query);				
			RETURN NEW;
		ELSE
			RAISE EXCEPTION '% is not a valid ISO8601 day code', quote_literal(tmp_day);
		END IF;
		
	END
$$ LANGUAGE plpgsql;
