package org.gcube.data.analysis.tabulardata.cube.data;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

import javax.enterprise.inject.Default;

/**
 * list resources available from the classpath @ *
 */
@Default
public class ResourceList implements ResourceFinder{

	
	
	/* (non-Javadoc)
	 * @see org.gcube.data.analysis.tabulardata.cube.data.ResourceFinder#getStream(java.lang.String)
	 */
	@Override
	public InputStream getStream(String file) {
		return ClassLoader.getSystemResourceAsStream(file);
	}

	/**
	 * for all elements of java.class.path get a Collection of resources Pattern
	 * pattern = Pattern.compile(".*"); gets all resources
	 * 
	 * @param pattern
	 *            the pattern to match
	 * @return the resources in the order they are found
	 */
	public Collection<String> getResourcesPath(
			final Pattern pattern){
		final ArrayList<String> retval = new ArrayList<String>();
		final String classPath = System.getProperty("java.class.path");
		
		final String[] classPathElements = classPath.split(":");
		for(final String element : classPathElements){
			retval.addAll(getResources(element, pattern));
		}
		return retval;
	}

	protected Collection<String> getResources(
			final String element,
			final Pattern pattern){
		final ArrayList<String> retval = new ArrayList<String>();
		final File file = new File(element);
		if(file.isDirectory()){
			retval.addAll(getResourcesFromDirectory(file, pattern));
		} else{
			retval.addAll(getResourcesFromJarFile(file, pattern));
		}
		return retval;
	}

	@SuppressWarnings("rawtypes")
	protected  Collection<String> getResourcesFromJarFile(
			final File file,
			final Pattern pattern){
		final ArrayList<String> retval = new ArrayList<String>();
		ZipFile zf;
		try{
			zf = new ZipFile(file);
		} catch(final ZipException e){
			throw new Error(e);
		} catch(final IOException e){
			throw new Error(e);
		}
		final Enumeration e = zf.entries();
		while(e.hasMoreElements()){
			final ZipEntry ze = (ZipEntry) e.nextElement();
			final String fileName = ze.getName();
			final boolean accept = pattern.matcher(fileName).matches();
			if(accept){
				retval.add(fileName);
			}
		}
		try{
			zf.close();
		} catch(final IOException e1){
			throw new Error(e1);
		}
		return retval;
	}

	protected  Collection<String> getResourcesFromDirectory(
			final File directory,
			final Pattern pattern){
		final ArrayList<String> retval = new ArrayList<String>();
		final File[] fileList = directory.listFiles();
		for(final File file : fileList){
			if(file.isDirectory()){
				retval.addAll(getResourcesFromDirectory(file, pattern));
			} else{
				final String fileName = file.getName();
				final boolean accept = pattern.matcher(fileName).matches();
				if(accept){
					retval.add(fileName);
				}

			}
		}
		return retval;
	}

}  