/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.cube.metadata.model;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.gcube.data.analysis.tabulardata.cube.metadata.model.JPAColumn;
import org.gcube.data.analysis.tabulardata.model.metadata.CubeMetadata;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableType;

@Entity(name="TDTable")
@NamedQueries(value={@NamedQuery(name="Table.findAll", query="SELECT t FROM TDTable AS t"), @NamedQuery(name="Table.findAllByType", query="SELECT t FROM TDTable AS t WHERE t.tableType = :TableType"), @NamedQuery(name="Table.findById", query="SELECT t FROM TDTable AS t WHERE t.id = :Id")})
@SequenceGenerator(name="tdtable_seq", sequenceName="tdtable_seq", allocationSize=1)
public class JPATable {
    @Id
    @Column(name="ID", nullable=false)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="tdtable_seq")
    private long id;
    private String name;
    private TableType tableType;
    private boolean exists;
    private Long parentTableId = null;
    @OneToMany(cascade={CascadeType.ALL})
    private Collection<JPAColumn> columns = Lists.newArrayList();
    private ArrayList<CubeMetadata<Serializable>> metadata = Lists.newArrayList();
    @Column(insertable=true, updatable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date createdTimestamp = new Date();
    @Column(insertable=true, updatable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date updatedTimestamp = new Date();

    private JPATable() {
    }

    public JPATable(Table table) {
        if (table.getId() != null) {
            this.id = table.getId();
        }
        this.name = table.getName();
        this.tableType = table.getTableType();
        for (org.gcube.data.analysis.tabulardata.model.column.Column column : table.getColumns()) {
            this.columns.add(new JPAColumn(column));
        }
        this.metadata.addAll(table.getAllMetadata());
        this.exists = table.exists();
        this.parentTableId = table.getParentTableId();
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public TableType getTableType() {
        return this.tableType;
    }

    public Collection<JPAColumn> getColumns() {
        return this.columns;
    }

    public Collection<CubeMetadata<Serializable>> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Collection<CubeMetadata<Serializable>> metadata) {
        this.metadata = Lists.newArrayList(metadata);
    }

    public Date getCreatedTimestamp() {
        return this.createdTimestamp;
    }

    public Date getUpdatedTimestamp() {
        return this.updatedTimestamp;
    }

    public boolean exists() {
        return this.exists;
    }

    public void setExists(boolean exists) {
        this.exists = exists;
    }

    public Long getParentTableId() {
        return this.parentTableId;
    }

    public void setParentTableId(Long parentTableId) {
        this.parentTableId = parentTableId;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("JPATable [id=");
        builder.append(this.id);
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", tableType=");
        builder.append(this.tableType);
        builder.append(", exists=");
        builder.append(this.exists);
        builder.append(", parentTableId=");
        builder.append(this.parentTableId);
        builder.append(", columns=");
        builder.append(this.columns);
        builder.append(", metadata=");
        builder.append(this.metadata);
        builder.append(", createdTimestamp=");
        builder.append(this.createdTimestamp);
        builder.append(", updatedTimestamp=");
        builder.append(this.updatedTimestamp);
        builder.append("]");
        return builder.toString();
    }
}

