package org.gcube.data.analysis.tabulardata.cube.metadata.model;

import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.table.Table;

public class JPATableFactory {
	
	public static JPATable createJPATable(Table table){
		JPATable result = new JPATable();
		result.setName(table.getName());
		result.setTableType(table.getTableType());
		for (Column column : table.getColumns()) {
			result.getColumns().add(JPAColumnFactory.createJPAColumn(column));
		}
		result.getMetadata().addAll(table.getAllMetadata());
		return result;
	}
	
	private static class JPAColumnFactory {
		
		public static JPAColumn createJPAColumn(Column column){
			JPAColumn result = new JPAColumn();
			result.setLocalId(column.getLocalId().getValue());
			result.setName(column.getName());
			result.setType(column.getColumnType());
			result.setDataType(column.getDataType());
			result.setRelationship(column.getRelationship());
			result.getMetadata().addAll(column.getAllMetadata());
			return result;
		}
		
	}

}
