/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.cube.metadata;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import javax.enterprise.inject.Default;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.NoResultException;
import javax.persistence.TypedQuery;
import org.gcube.data.analysis.tabulardata.cube.metadata.CubeMetadataWrangler;
import org.gcube.data.analysis.tabulardata.cube.metadata.ISEntityManagerProvider;
import org.gcube.data.analysis.tabulardata.cube.metadata.TableConsistencyChecker;
import org.gcube.data.analysis.tabulardata.cube.metadata.exceptions.NoSuchTableException;
import org.gcube.data.analysis.tabulardata.cube.metadata.model.JPATable;
import org.gcube.data.analysis.tabulardata.cube.metadata.model.JPATableFactory;
import org.gcube.data.analysis.tabulardata.cube.metadata.model.TableFactory;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.model.table.TableType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Default
@Singleton
public class JPACubeMetadataWrangler
implements CubeMetadataWrangler {
    Logger log = LoggerFactory.getLogger(JPACubeMetadataWrangler.class);
    EntityManagerFactory emf = null;
    ISEntityManagerProvider emp;

    @Inject
    public JPACubeMetadataWrangler(ISEntityManagerProvider emp) {
        this.emp = emp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Table save(Table table, boolean overwrite) {
        TableConsistencyChecker.checkTableConsistency(table);
        JPATable jpaTable = null;
        try (EntityManager em = this.getEntityManagerFactory().createEntityManager();){
            if (overwrite) {
                try {
                    jpaTable = JPATableFactory.updateJPATable(this.getJPATableById(table.getId().getValue(), em), table);
                }
                catch (NoSuchTableException e) {
                    this.log.warn("the table with id {} is not persisted, cannot overwrite ", (Object)table.getId().getValue());
                }
            }
            if (jpaTable == null) {
                jpaTable = JPATableFactory.createJPATable(table);
            }
            this.persistEntity(jpaTable, em);
            Table table2 = TableFactory.createTable(jpaTable);
            return table2;
        }
    }

    private void initializeIfNot() {
        if (this.emf == null) {
            this.emf = this.emp.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Table get(TableId id) throws NoSuchTableException {
        try (EntityManager em = this.getEntityManagerFactory().createEntityManager();){
            Table table = TableFactory.createTable(this.getJPATableById(id.getValue(), em));
            return table;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Table getTableByName(String name) throws NoSuchTableException {
        try (EntityManager em = this.getEntityManagerFactory().createEntityManager();){
            Table table = TableFactory.createTable(this.getJPATableByTableName(name, em));
            return table;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized List<Table> getAll() {
        try (EntityManager em = this.getEntityManagerFactory().createEntityManager();){
            List list = Lists.transform(this.getAllJPATables(em), (Function)new Function<JPATable, Table>(){

                public Table apply(JPATable input) {
                    return TableFactory.createTable(input);
                }
            });
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized List<Table> getAll(TableType tableType) {
        try (EntityManager em = this.getEntityManagerFactory().createEntityManager();){
            List list = Lists.transform(this.getAllJPATablesByType(tableType, em), (Function)new Function<JPATable, Table>(){

                public Table apply(JPATable input) {
                    return TableFactory.createTable(input);
                }
            });
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void remove(TableId id) throws NoSuchTableException {
        try (EntityManager em = this.getEntityManagerFactory().createEntityManager();){
            this.removeEntity(this.getJPATableById(id.getValue(), em), em);
        }
    }

    private JPATable getJPATableById(long id, EntityManager em) throws NoSuchTableException {
        JPATable table = (JPATable)em.find(JPATable.class, (Object)id);
        if (table == null) {
            throw new NoSuchTableException(id);
        }
        return table;
    }

    private JPATable getJPATableByTableName(String name, EntityManager em) throws NoSuchTableException {
        TypedQuery query = em.createNamedQuery("Table.findByName", JPATable.class);
        query.setParameter("Name", (Object)name);
        try {
            return (JPATable)query.getSingleResult();
        }
        catch (NoResultException e) {
            throw new NoSuchTableException(name);
        }
    }

    private List<JPATable> getAllJPATables(EntityManager em) {
        TypedQuery query = em.createNamedQuery("Table.findAll", JPATable.class);
        return query.getResultList();
    }

    private List<JPATable> getAllJPATablesByType(TableType tableType, EntityManager em) {
        TypedQuery query = em.createNamedQuery("Table.findAllByType", JPATable.class);
        query.setParameter("TableType", (Object)tableType);
        return query.getResultList();
    }

    private void persistEntity(JPATable entity, EntityManager em) {
        try {
            em.getTransaction().begin();
            if (!em.contains((Object)entity)) {
                em.persist((Object)entity);
            } else {
                em.merge((Object)entity);
            }
            em.flush();
            em.getTransaction().commit();
        }
        catch (Throwable t) {
            this.log.warn("DB error", t);
            em.getTransaction().rollback();
        }
    }

    private void removeEntity(Object entity, EntityManager em) {
        em.getTransaction().begin();
        em.remove(entity);
        em.flush();
        em.getTransaction().commit();
    }

    private EntityManagerFactory getEntityManagerFactory() {
        this.initializeIfNot();
        return this.emf;
    }
}

