/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.cube.tablemanagers;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gcube.data.analysis.tabulardata.cube.data.DatabaseWrangler;
import org.gcube.data.analysis.tabulardata.cube.metadata.CubeMetadataWrangler;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.DefaultTableCreator;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableManager;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.IdColumn;
import org.gcube.data.analysis.tabulardata.model.table.Table;

public abstract class StatefulTableCreator
extends DefaultTableCreator {
    private List<Column> newColumns = Lists.newArrayList();
    private Table clonedTable = null;
    private List<Column> columnsToRemove = Lists.newArrayList();
    private boolean withData = false;

    public StatefulTableCreator(DatabaseWrangler dw, CubeMetadataWrangler cmw, TableManager tm) {
        super(dw, cmw, tm);
    }

    @Override
    protected Collection<Column> getAllColumns() {
        ArrayList columns = Lists.newArrayList();
        if (this.clonedTable != null) {
            ArrayList clonedColumns = Lists.newArrayList((Iterable)this.clonedTable.getColumns());
            clonedColumns.removeAll(this.columnsToRemove);
            columns.addAll(clonedColumns);
        }
        columns.addAll(this.newColumns);
        while (columns.remove(new IdColumn())) {
        }
        return columns;
    }

    @Override
    protected Collection<Column> getNewColumns() {
        ArrayList columns = Lists.newArrayList();
        columns.addAll(this.newColumns);
        return columns;
    }

    @Override
    protected void addNewColumn(Column column) {
        this.newColumns.add(column);
    }

    @Override
    protected Table getTableToClone() {
        return this.clonedTable;
    }

    @Override
    protected void setTableToClone(Table table) {
        this.clonedTable = table;
    }

    @Override
    protected boolean isCloneWithData() {
        return this.withData;
    }

    @Override
    protected void setCloneWithData(boolean cloneWithData) {
        this.withData = cloneWithData;
    }

    @Override
    protected Collection<Column> getColumnsToRemove() {
        return this.columnsToRemove;
    }

    @Override
    protected void setColumnsToRemove(Collection<Column> columns) {
        this.columnsToRemove = Lists.newArrayList(columns);
    }
}

