/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.cube.tablemanagers;

import java.util.Collection;
import javax.enterprise.inject.Default;
import javax.inject.Inject;
import org.gcube.data.analysis.tabulardata.cube.data.DatabaseWrangler;
import org.gcube.data.analysis.tabulardata.cube.exceptions.CubeManagerException;
import org.gcube.data.analysis.tabulardata.cube.metadata.CubeMetadataWrangler;
import org.gcube.data.analysis.tabulardata.cube.metadata.exceptions.NoSuchTableException;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableManager;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableType;

@Default
public class TableManagerImpl
implements TableManager {
    private DatabaseWrangler dbWrangler;
    private CubeMetadataWrangler cmWrangler;

    @Inject
    public TableManagerImpl(DatabaseWrangler dbWrangler, CubeMetadataWrangler cmWrangler) {
        this.dbWrangler = dbWrangler;
        this.cmWrangler = cmWrangler;
    }

    @Override
    public Collection<Table> getAll() {
        return this.cmWrangler.getAll();
    }

    @Override
    public Collection<Table> getAll(TableType tableType) {
        return this.cmWrangler.getAll(tableType);
    }

    @Override
    public Table get(long id) throws org.gcube.data.analysis.tabulardata.cube.exceptions.NoSuchTableException {
        try {
            return this.cmWrangler.get(id);
        }
        catch (NoSuchTableException e) {
            throw new org.gcube.data.analysis.tabulardata.cube.exceptions.NoSuchTableException(e.getId());
        }
    }

    @Override
    public void remove(long id) throws org.gcube.data.analysis.tabulardata.cube.exceptions.NoSuchTableException {
        Table table = this.get(id);
        this.dbWrangler.removeTable(table.getName());
        table.setExists(false);
        this.cmWrangler.update(table);
    }

    @Override
    public void updateMetadata(Table table) throws CubeManagerException {
        Table t = this.get(table.getId());
        if (!table.sameStructureAs(t)) {
            throw new CubeManagerException("Provided table does not have the same structure of registered table.");
        }
        this.cmWrangler.update(table);
    }

    @Override
    public void removeRaw(long id) throws org.gcube.data.analysis.tabulardata.cube.exceptions.NoSuchTableException {
        Table table = this.get(id);
        this.dbWrangler.removeTable(table.getName());
        this.removeTableMetadata(table.getId());
    }

    private void removeTableMetadata(long id) throws org.gcube.data.analysis.tabulardata.cube.exceptions.NoSuchTableException {
        try {
            this.cmWrangler.remove(id);
        }
        catch (NoSuchTableException e) {
            throw new org.gcube.data.analysis.tabulardata.cube.exceptions.NoSuchTableException(id);
        }
    }
}

