package org.gcube.data.analysis.tabulardata.cube.tablemanagers;

import java.util.Collection;
import java.util.List;

import org.gcube.data.analysis.tabulardata.cube.data.DatabaseWrangler;
import org.gcube.data.analysis.tabulardata.cube.metadata.CubeMetadataWrangler;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.IdColumn;
import org.gcube.data.analysis.tabulardata.model.table.Table;

import com.google.common.collect.Lists;

public abstract class StatefulTableCreator extends DefaultTableCreator{

	private List<Column> newColumns = Lists.newArrayList();

	// Following attributes are used for cloning
	private Table clonedTable = null;
	private List<Column> columnsToRemove = Lists.newArrayList();
	private boolean withData = false;

	public StatefulTableCreator(DatabaseWrangler dw, CubeMetadataWrangler cmw, TableManager tm) {
		super(dw, cmw, tm);
	}

	@Override
	protected Collection<Column> getAllColumns() {
		List<Column> columns = Lists.newArrayList();
		if (clonedTable != null) {
			Collection<Column> clonedColumns = Lists.newArrayList(clonedTable.getColumns());
			clonedColumns.removeAll(columnsToRemove);
			columns.addAll(clonedColumns);
		}
		columns.addAll(newColumns);
		// Make sure that IdColumn is not on the list
		while (columns.remove(new IdColumn()))
			;
		return columns;
	}

	@Override
	protected Collection<Column> getNewColumns() {
		List<Column> columns = Lists.newArrayList();
		columns.addAll(newColumns);
		return columns;
	}

	@Override
	protected void addNewColumn(Column column) {
		newColumns.add(column);
	}

	@Override
	protected Table getTableToClone() {
		return clonedTable;
	}

	@Override
	protected void setTableToClone(Table table) {
		this.clonedTable = table;
	}

	@Override
	protected boolean isCloneWithData() {
		return withData;
	}

	@Override
	protected void setCloneWithData(boolean cloneWithData) {
		withData = cloneWithData;
	}

	@Override
	protected Collection<Column> getColumnsToRemove() {
		return columnsToRemove;
	}

	@Override
	protected void setColumnsToRemove(Collection<Column> columns) {
		columnsToRemove = Lists.newArrayList(columns);
	}

}
