package org.gcube.data.analysis.tabulardata.cube.tablemanagers.codelist;

import java.util.Collection;
import java.util.List;

import org.gcube.data.analysis.tabulardata.cube.data.DatabaseWrangler;
import org.gcube.data.analysis.tabulardata.cube.metadata.CubeMetadataWrangler;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.DefaultTableCreator;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableManager;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeDescriptionColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeNameColumnType;
import org.gcube.data.analysis.tabulardata.model.table.type.CodelistTableType;

import com.google.common.collect.Lists;

public class CodelistCreator extends DefaultTableCreator {

	public CodelistCreator(DatabaseWrangler dw, CubeMetadataWrangler cmw, TableManager tm) {
		super(dw, cmw, tm, new CodelistTableType());
	}

	private static List<ColumnType> indexedColumnTypes = Lists.newArrayList(new CodeColumnType(),
			new CodeNameColumnType(), new CodeDescriptionColumnType());

	@Override
	protected void addIndexes(String tableName, Collection<Column> columns) {
		for (Column column : columns) {
			if (indexedColumnTypes.contains(column.getColumnType()))
				dbWrangler.createIndex(tableName, column.getName());
		}
	}

}
