/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.cube.time;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.data.analysis.tabulardata.cube.data.DatabaseWrangler;
import org.gcube.data.analysis.tabulardata.cube.metadata.CubeMetadataWrangler;
import org.gcube.data.analysis.tabulardata.cube.time.TimeCodelistCreator;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.factories.AttributeColumnFactory;
import org.gcube.data.analysis.tabulardata.model.column.factories.CodeColumnFactory;
import org.gcube.data.analysis.tabulardata.model.column.factories.IdColumnFactory;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.IdColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.datatype.DateType;
import org.gcube.data.analysis.tabulardata.model.datatype.IntegerType;
import org.gcube.data.analysis.tabulardata.model.datatype.TextType;
import org.gcube.data.analysis.tabulardata.model.metadata.table.TableMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.TimePeriodTypeMetadata;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableType;
import org.gcube.data.analysis.tabulardata.model.table.type.TimeCodelistTableType;
import org.gcube.data.analysis.tabulardata.model.time.PeriodType;

@Singleton
public class DayCodelistCreator
implements TimeCodelistCreator {
    @Inject
    DatabaseWrangler dbWrangler;
    @Inject
    CubeMetadataWrangler cmWrangler;

    @Override
    public Table createTable() {
        Table dayCodelist = this.createTableMeta();
        String tableName = this.createTableOnDBWithColumns(dayCodelist.getColumns());
        dayCodelist.setName(tableName);
        return this.cmWrangler.save(dayCodelist, false);
    }

    private Table createTableMeta() {
        ArrayList columns = Lists.newArrayList((Object[])new Column[]{IdColumnFactory.create(), this.createCodeColumn(), this.createDayColumn(), this.createMonthColumn(), this.createQuarterColumn(), this.createYearColumn(), this.createDecadeColumn(), this.createIsoWeekColumn(), this.createIsoYearColumn()});
        Table dayCodelist = new Table((TableType)new TimeCodelistTableType());
        dayCodelist.setColumns((List)columns);
        dayCodelist.setMetadata((TableMetadata)new TimePeriodTypeMetadata(this.getManagedPeriodType()));
        return dayCodelist;
    }

    private String createTableOnDBWithColumns(List<Column> columns) {
        String tableName = this.dbWrangler.createTable();
        for (Column column : columns) {
            if (column.getColumnType() instanceof IdColumnType) continue;
            this.dbWrangler.addColumn(tableName, column.getName(), column.getDataType());
            this.dbWrangler.setNullable(tableName, column.getName(), false);
            if (!(column.getColumnType() instanceof CodeColumnType)) continue;
            this.dbWrangler.createUniqueIndex(tableName, column.getName());
        }
        this.dbWrangler.createInsertUpdateTriggerOnTable("update_time_dimension_" + tableName, tableName, "update_gregorian_day_dimension");
        return tableName;
    }

    private Column createIsoYearColumn() {
        Column resultColumn = AttributeColumnFactory.create((DataType)new IntegerType());
        resultColumn.setName("iso_year");
        return resultColumn;
    }

    private Column createDecadeColumn() {
        Column resultColumn = AttributeColumnFactory.create((DataType)new IntegerType());
        resultColumn.setName("decade");
        return resultColumn;
    }

    private Column createYearColumn() {
        Column yearColumn = AttributeColumnFactory.create((DataType)new IntegerType());
        yearColumn.setName("year");
        return yearColumn;
    }

    private Column createQuarterColumn() {
        Column quarterColumn = AttributeColumnFactory.create((DataType)new IntegerType());
        quarterColumn.setName("quarter_of_year");
        return quarterColumn;
    }

    private Column createCodeColumn() {
        Column codeColumn = CodeColumnFactory.create();
        codeColumn.setName("day_code");
        codeColumn.setDataType((DataType)new TextType(10));
        return codeColumn;
    }

    private Column createDayColumn() {
        Column dayColumn = AttributeColumnFactory.create((DataType)new DateType());
        dayColumn.setName("the_day");
        return dayColumn;
    }

    private Column createMonthColumn() {
        Column monthColumn = AttributeColumnFactory.create((DataType)new IntegerType());
        monthColumn.setName("month_of_year");
        return monthColumn;
    }

    private Column createIsoWeekColumn() {
        Column isoWeekColumn = AttributeColumnFactory.create((DataType)new IntegerType());
        isoWeekColumn.setName("week_of_iso_year");
        return isoWeekColumn;
    }

    @Override
    public PeriodType getManagedPeriodType() {
        return PeriodType.DAY;
    }
}

