/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.cube.time;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.gcube.data.analysis.tabulardata.cube.data.DatabaseWrangler;
import org.gcube.data.analysis.tabulardata.cube.metadata.CubeMetadataWrangler;
import org.gcube.data.analysis.tabulardata.cube.time.TimeCodelistCreator;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.factories.AttributeColumnFactory;
import org.gcube.data.analysis.tabulardata.model.column.factories.CodeColumnFactory;
import org.gcube.data.analysis.tabulardata.model.column.factories.IdColumnFactory;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.IdColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.datatype.IntegerType;
import org.gcube.data.analysis.tabulardata.model.datatype.TextType;
import org.gcube.data.analysis.tabulardata.model.metadata.table.TableMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.TimePeriodTypeMetadata;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableType;
import org.gcube.data.analysis.tabulardata.model.table.type.TimeCodelistTableType;
import org.gcube.data.analysis.tabulardata.model.time.PeriodType;

public class MonthCodelistCreator
implements TimeCodelistCreator {
    @Inject
    DatabaseWrangler dbWrangler;
    @Inject
    CubeMetadataWrangler cmWrangler;

    @Override
    public Table createTable() {
        Table codelist = this.createTableMeta();
        String tableName = this.createTableOnDBWithColumns(codelist.getColumns());
        codelist.setName(tableName);
        return this.cmWrangler.save(codelist, false);
    }

    private Table createTableMeta() {
        ArrayList columns = Lists.newArrayList((Object[])new Column[]{IdColumnFactory.create(), this.createCodeColumn(), this.createMonthColumn(), this.createQuarterColumn(), this.createYearColumn(), this.createDecadeColumn()});
        Table dayCodelist = new Table((TableType)new TimeCodelistTableType());
        dayCodelist.setColumns((List)columns);
        dayCodelist.setMetadata((TableMetadata)new TimePeriodTypeMetadata(this.getManagedPeriodType()));
        return dayCodelist;
    }

    private String createTableOnDBWithColumns(List<Column> columns) {
        String tableName = this.dbWrangler.createTable();
        for (Column column : columns) {
            if (column.getColumnType() instanceof IdColumnType) continue;
            this.dbWrangler.addColumn(tableName, column.getName(), column.getDataType());
            this.dbWrangler.setNullable(tableName, column.getName(), false);
            if (!(column.getColumnType() instanceof CodeColumnType)) continue;
            this.dbWrangler.createUniqueIndex(tableName, column.getName());
        }
        this.dbWrangler.createInsertUpdateTriggerOnTable("update_time_dimension_" + tableName, tableName, "update_gregorian_month_dimension");
        return tableName;
    }

    private Column createDecadeColumn() {
        Column resultColumn = AttributeColumnFactory.create((DataType)new IntegerType());
        resultColumn.setName("decade");
        return resultColumn;
    }

    private Column createYearColumn() {
        Column yearColumn = AttributeColumnFactory.create((DataType)new IntegerType());
        yearColumn.setName("year");
        return yearColumn;
    }

    private Column createQuarterColumn() {
        Column quarterColumn = AttributeColumnFactory.create((DataType)new IntegerType());
        quarterColumn.setName("quarter_of_year");
        return quarterColumn;
    }

    private Column createCodeColumn() {
        Column codeColumn = CodeColumnFactory.create();
        codeColumn.setName("month_code");
        codeColumn.setDataType((DataType)new TextType(7));
        return codeColumn;
    }

    private Column createMonthColumn() {
        Column monthColumn = AttributeColumnFactory.create((DataType)new IntegerType());
        monthColumn.setName("month_of_year");
        return monthColumn;
    }

    @Override
    public PeriodType getManagedPeriodType() {
        return PeriodType.MONTH;
    }
}

