/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.cube.tablemanagers;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.RandomStringUtils;
import org.gcube.data.analysis.tabulardata.cube.data.DatabaseWrangler;
import org.gcube.data.analysis.tabulardata.cube.exceptions.NoSuchTableException;
import org.gcube.data.analysis.tabulardata.cube.exceptions.TableCreationException;
import org.gcube.data.analysis.tabulardata.cube.metadata.CubeMetadataWrangler;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableCreator;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableManager;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.column.factories.IdColumnFactory;
import org.gcube.data.analysis.tabulardata.model.column.type.IdColumnType;
import org.gcube.data.analysis.tabulardata.model.idioms.ColumnHasName;
import org.gcube.data.analysis.tabulardata.model.metadata.table.TableMetadata;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableType;

public abstract class DefaultTableCreator
implements TableCreator {
    protected DatabaseWrangler dbWrangler;
    protected CubeMetadataWrangler mdWrangler;
    protected TableManager tableManager;
    protected List<Column> newTableColumns = Lists.newArrayList();
    protected List<Column> newDBColumns = Lists.newArrayList();
    protected Table tableToClone = null;
    protected Set<Column> columnsToRemove = Sets.newHashSet();
    protected boolean copyData = false;
    private TableType tableType;

    public DefaultTableCreator(DatabaseWrangler dbWrangler, CubeMetadataWrangler mdWrangler, TableManager tableManager, TableType tableType) {
        this.dbWrangler = dbWrangler;
        this.mdWrangler = mdWrangler;
        this.tableManager = tableManager;
        this.tableType = tableType;
    }

    public TableCreator addColumn(Column column) {
        this.checkColumnToAdd(column);
        this.newTableColumns.add(column);
        this.newDBColumns.add(column);
        return this;
    }

    public TableCreator addColumnAfter(Column columnToAdd, Column columnBefore) {
        this.checkColumnToAdd(columnToAdd);
        int index = this.newTableColumns.indexOf(columnBefore);
        if (index == -1) {
            throw new IllegalArgumentException(columnBefore + " not found");
        }
        this.newTableColumns.add(index + 1, columnToAdd);
        this.newDBColumns.add(columnToAdd);
        return this;
    }

    public TableCreator addColumnBefore(Column columnToAdd, Column columnAfter) {
        this.checkColumnToAdd(columnToAdd);
        int index = this.newTableColumns.indexOf(columnAfter);
        if (index == -1) {
            throw new IllegalArgumentException(columnAfter + " not found");
        }
        this.newTableColumns.add(index, columnToAdd);
        this.newDBColumns.add(columnToAdd);
        return this;
    }

    public TableCreator addColumns(Column ... columns) {
        for (Column column : columns) {
            this.addColumn(column);
        }
        return this;
    }

    public TableCreator addColumnsAfter(Column columnBefore, Column ... columns) {
        for (Column column : columns) {
            this.addColumnAfter(column, columnBefore);
        }
        return this;
    }

    public TableCreator addColumnsBefore(Column columnAfter, Column ... columns) {
        for (Column column : columns) {
            this.addColumnBefore(column, columnAfter);
        }
        return this;
    }

    private void checkColumnToAdd(Column column) {
        if (!this.isAllowedColumn(column)) {
            throw new IllegalArgumentException("Invalid column type: " + column.getColumnType());
        }
    }

    protected final boolean isAllowedColumn(Column column) {
        return !column.getColumnType().equals((Object)new IdColumnType());
    }

    public TableCreator like(Table table, boolean copyData) {
        return this.like(table, copyData, new ArrayList<Column>(0));
    }

    public TableCreator like(Table table, boolean copyData, List<Column> columnsToRemove) {
        this.tableToClone = table;
        this.copyData = copyData;
        this.newTableColumns = new ArrayList<Column>(table.getColumns());
        this.removeColumns(columnsToRemove);
        return this;
    }

    private void removeColumns(List<Column> columnsToRemove) {
        if (this.tableToClone == null) {
            return;
        }
        this.columnsToRemove = Sets.newHashSet();
        for (Column columnToRemove : columnsToRemove) {
            this.removeColumn(columnToRemove);
        }
    }

    private void removeColumn(Column columnToRemove) {
        if (this.tableToClone.getColumns().contains(columnToRemove)) {
            this.columnsToRemove.add(columnToRemove);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table create() throws TableCreationException {
        try {
            this.checkConsistency();
            this.setColumnNames();
            String tableName = null;
            if (this.tableToClone != null) {
                tableName = this.dbWrangler.cloneTable(this.tableToClone.getName(), this.copyData, false);
                for (Column column : this.columnsToRemove) {
                    this.dbWrangler.removeColumn(tableName, column.getName());
                }
                for (Column column : this.newDBColumns) {
                    this.dbWrangler.addColumn(tableName, column.getName(), column.getDataType());
                }
            } else {
                tableName = this.dbWrangler.createTable();
                for (Column column : this.newDBColumns) {
                    this.dbWrangler.addColumn(tableName, column.getName(), column.getDataType());
                }
            }
            this.addIndexes(tableName, this.getAllColumnsExceptId());
            ArrayList columns = Lists.newArrayList((Object[])new Column[]{this.createIdColumn()});
            columns.addAll(this.getAllColumnsExceptId());
            Table newTable = this.createBaseTable(tableName, columns);
            if (this.tableToClone != null) {
                this.cloneMetadata(this.tableToClone, newTable);
            }
            Table table = this.mdWrangler.save(newTable, false);
            return table;
        }
        finally {
            this.resetTableCreator();
        }
    }

    private void resetTableCreator() {
        this.newTableColumns = Lists.newArrayList();
        this.newDBColumns = Lists.newArrayList();
        this.tableToClone = null;
        this.columnsToRemove = Sets.newHashSet();
        this.copyData = false;
    }

    protected void checkConsistency() throws TableCreationException {
        try {
            this.checkColumnsRelationship();
        }
        catch (Exception e) {
            throw new TableCreationException(e.getMessage());
        }
    }

    private void checkColumnsRelationship() throws Exception {
        for (Column column : this.getAllColumnsExceptId()) {
            if (!column.hasRelationship()) continue;
            try {
                Table targetTable = this.tableManager.get(column.getRelationship().getTargetTableId());
                targetTable.getColumnById(column.getRelationship().getTargetColumnId());
            }
            catch (NoSuchTableException e) {
                throw new Exception(String.format("Referenced Codelist with ID %1$s does not exists.", column.getRelationship().getTargetTableId()));
            }
        }
    }

    protected void setColumnNames() {
        List<Column> columns = this.newDBColumns;
        for (Column column : columns) {
            String eligibleName;
            if (column.hasName()) continue;
            while (!Collections2.filter(this.newTableColumns, (Predicate)new ColumnHasName(eligibleName = ColumnNameGenerator.generateColumnName())).isEmpty()) {
            }
            column.setName(eligibleName);
        }
    }

    protected Table createBaseTable(String tableName, List<Column> columns) {
        Table result = new Table(this.tableType);
        result.setColumns(columns);
        result.setName(tableName);
        return result;
    }

    protected void cloneMetadata(Table sourceTable, Table destTable) {
        for (TableMetadata m : sourceTable.getAllMetadata()) {
            if (!m.isInheritable()) continue;
            destTable.setMetadata(m);
        }
    }

    private List<Column> getAllColumnsExceptId() {
        ArrayList result = Lists.newArrayList(this.newTableColumns);
        if (this.tableToClone != null) {
            result.removeAll(this.columnsToRemove);
            result.removeAll(this.tableToClone.getColumnsByType(new ColumnType[]{new IdColumnType()}));
        }
        return result;
    }

    protected abstract void addIndexes(String var1, Collection<Column> var2);

    protected Column createIdColumn() {
        return IdColumnFactory.create();
    }

    public static class ColumnNameGenerator {
        public static String generateColumnName() {
            return RandomStringUtils.random((int)6, (boolean)true, (boolean)false).toLowerCase();
        }
    }
}

