/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.cube.tablemanagers;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.event.Event;
import org.apache.commons.lang.RandomStringUtils;
import org.gcube.data.analysis.tabulardata.cube.data.DatabaseWrangler;
import org.gcube.data.analysis.tabulardata.cube.events.TableCreationEvent;
import org.gcube.data.analysis.tabulardata.cube.exceptions.NoSuchTableException;
import org.gcube.data.analysis.tabulardata.cube.exceptions.TableCreationException;
import org.gcube.data.analysis.tabulardata.cube.metadata.CubeMetadataWrangler;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableCreator;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableManager;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.column.factories.IdColumnFactory;
import org.gcube.data.analysis.tabulardata.model.column.type.IdColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.TimeDimensionColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.idioms.ColumnHasName;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ColumnMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.column.PeriodTypeMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.TableMetadata;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DefaultTableCreator
implements TableCreator {
    Event<TableCreationEvent> tableCreatedEvent;
    private static Logger logger = LoggerFactory.getLogger(DefaultTableCreator.class);
    protected DatabaseWrangler dbWrangler;
    protected CubeMetadataWrangler mdWrangler;
    protected TableManager tableManager;
    protected List<Column> newTableColumns = Lists.newArrayList();
    protected List<Column> newDBColumns = Lists.newArrayList();
    protected Table tableToClone = null;
    protected Set<Column> columnsToRemove = Sets.newHashSet();
    protected boolean copyData = false;
    Map<Column, DataType> columnAlterMap = new HashMap<Column, DataType>();
    private TableType tableType;

    public DefaultTableCreator(DatabaseWrangler dbWrangler, CubeMetadataWrangler mdWrangler, TableManager tableManager, TableType tableType, Event<TableCreationEvent> tableCreatedEvent) {
        this.dbWrangler = dbWrangler;
        this.mdWrangler = mdWrangler;
        this.tableManager = tableManager;
        this.tableType = tableType;
        this.tableCreatedEvent = tableCreatedEvent;
    }

    public TableCreator addColumn(Column column) {
        this.checkColumnToAdd(column);
        this.newTableColumns.add(column);
        this.newDBColumns.add(column);
        return this;
    }

    public TableCreator addColumnAfter(Column columnToAdd, Column columnBefore) {
        this.checkColumnToAdd(columnToAdd);
        int index = this.newTableColumns.indexOf(columnBefore);
        if (index == -1) {
            throw new IllegalArgumentException(columnBefore + " not found");
        }
        this.newTableColumns.add(index + 1, columnToAdd);
        this.newDBColumns.add(columnToAdd);
        return this;
    }

    public TableCreator addColumnFirst(Column columnToAdd) {
        this.checkColumnToAdd(columnToAdd);
        this.newTableColumns.add(0, columnToAdd);
        this.newDBColumns.add(columnToAdd);
        return this;
    }

    public TableCreator addColumnBefore(Column columnToAdd, Column columnAfter) {
        this.checkColumnToAdd(columnToAdd);
        int index = this.newTableColumns.indexOf(columnAfter);
        if (index == -1) {
            throw new IllegalArgumentException(columnAfter + " not found");
        }
        this.newTableColumns.add(index, columnToAdd);
        this.newDBColumns.add(columnToAdd);
        return this;
    }

    public TableCreator addColumns(Column ... columns) {
        for (Column column : columns) {
            this.addColumn(column);
        }
        return this;
    }

    public TableCreator addColumnsAfter(Column columnBefore, Column ... columns) {
        for (Column column : columns) {
            this.addColumnAfter(column, columnBefore);
        }
        return this;
    }

    public TableCreator addColumnsBefore(Column columnAfter, Column ... columns) {
        for (Column column : columns) {
            this.addColumnBefore(column, columnAfter);
        }
        return this;
    }

    public TableCreator removeColumn(Column columnToRemove) {
        this.removeColumnInternal(columnToRemove);
        return this;
    }

    private void checkColumnToAdd(Column column) {
        if (!this.isAllowedColumn(column)) {
            throw new IllegalArgumentException("Invalid column type: " + column.getColumnType());
        }
    }

    protected final boolean isAllowedColumn(Column column) {
        return !column.getColumnType().equals((Object)new IdColumnType());
    }

    public TableCreator like(Table table, boolean copyData) {
        return this.like(table, copyData, new ArrayList<Column>(0));
    }

    public TableCreator like(Table table, boolean copyData, List<Column> columnsToRemove) {
        this.tableToClone = table;
        this.copyData = copyData;
        this.newTableColumns = new ArrayList<Column>();
        for (Column column : table.getColumnsExceptTypes(new Class[]{IdColumnType.class})) {
            Column newColumn = new Column(column.getLocalId(), column.getDataType(), column.getColumnType());
            newColumn.setName(column.getName());
            if (column.hasRelationship()) {
                newColumn.setRelationship(column.getRelationship());
            }
            ArrayList<ColumnMetadata> metadataToReuse = new ArrayList<ColumnMetadata>();
            for (ColumnMetadata metadata : column.getAllMetadata()) {
                if (!metadata.isInheritable()) continue;
                metadataToReuse.add(metadata);
            }
            if (!metadataToReuse.isEmpty()) {
                newColumn.setAllMetadata(metadataToReuse);
            }
            this.newTableColumns.add(newColumn);
        }
        this.removeColumnsInternal(columnsToRemove);
        return this;
    }

    private void removeColumnsInternal(List<Column> columnsToRemove) {
        if (this.tableToClone == null) {
            return;
        }
        this.columnsToRemove = Sets.newHashSet();
        for (Column columnToRemove : columnsToRemove) {
            this.removeColumnInternal(columnToRemove);
        }
    }

    private void removeColumnInternal(Column columnToRemove) {
        if (this.tableToClone.getColumns().contains(columnToRemove)) {
            this.columnsToRemove.add(columnToRemove);
            this.newTableColumns.remove(columnToRemove);
        }
    }

    public TableCreator changeColumnType(Column column, DataType newType) {
        this.columnAlterMap.put(column, newType);
        return this;
    }

    public Table create() throws TableCreationException {
        return this.create(null);
    }

    public Table create(String selectedTableName) throws TableCreationException {
        try {
            this.checkConsistency();
            this.setColumnNames();
            String tableName = selectedTableName;
            if (this.tableToClone != null) {
                tableName = this.dbWrangler.cloneTable(this.tableToClone.getName(), this.copyData, false);
                for (Column column : this.columnsToRemove) {
                    this.dbWrangler.removeColumn(tableName, column.getName());
                }
                for (Column column : this.newDBColumns) {
                    this.dbWrangler.addColumn(tableName, column.getName(), column.getDataType(), column.getCreationDefaultValue());
                }
                for (Map.Entry entry : this.columnAlterMap.entrySet()) {
                    this.dbWrangler.alterColumnType(tableName, ((Column)entry.getKey()).getName(), (DataType)entry.getValue());
                }
            } else {
                if (selectedTableName == null) {
                    tableName = this.dbWrangler.createTable();
                } else {
                    this.dbWrangler.createTable(selectedTableName);
                }
                for (Column column : this.newDBColumns) {
                    this.dbWrangler.addColumn(tableName, column.getName(), column.getDataType(), column.getCreationDefaultValue());
                }
            }
            Column idColumn = this.createIdColumn();
            if (this.tableToClone != null) {
                idColumn.setLocalId(((Column)this.tableToClone.getColumnsByType(new Class[]{IdColumnType.class}).get(0)).getLocalId());
            }
            ArrayList arrayList = Lists.newArrayList((Object[])new Column[]{idColumn});
            arrayList.addAll(this.getAllColumnsExceptId());
            this.addIndexes(tableName, arrayList);
            Table newTable = this.createBaseTable(tableName, arrayList);
            if (this.tableToClone != null) {
                this.cloneMetadata(this.tableToClone, newTable);
            }
            Table createdTable = this.mdWrangler.save(newTable, false);
            this.tableCreatedEvent.fire((Object)new TableCreationEvent(createdTable));
            Table table = createdTable;
            return table;
        }
        catch (TableCreationException tce) {
            throw tce;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new TableCreationException(e.getMessage());
        }
        finally {
            this.resetTableCreator();
        }
    }

    private void resetTableCreator() {
        this.newTableColumns = Lists.newArrayList();
        this.newDBColumns = Lists.newArrayList();
        this.tableToClone = null;
        this.columnsToRemove = Sets.newHashSet();
        this.copyData = false;
    }

    protected void checkConsistency() throws TableCreationException {
        try {
            this.checkColumnsRelationship();
        }
        catch (Exception e) {
            throw new TableCreationException(e.getMessage());
        }
    }

    private void checkColumnsRelationship() throws Exception {
        for (Column column : this.getAllColumnsExceptId()) {
            if (!column.hasRelationship()) continue;
            try {
                if (column.getColumnType() instanceof TimeDimensionColumnType && column.contains(PeriodTypeMetadata.class)) continue;
                Table targetTable = this.tableManager.get(column.getRelationship().getTargetTableId());
                targetTable.getColumnById(column.getRelationship().getTargetColumnId());
            }
            catch (NoSuchTableException e) {
                throw new Exception(String.format("Referenced Codelist with ID %1$s does not exists.", column.getRelationship().getTargetTableId()));
            }
        }
    }

    protected void setColumnNames() {
        List<Column> columns = this.newDBColumns;
        for (Column column : columns) {
            String eligibleName;
            if (column.hasName()) continue;
            while (!Collections2.filter(this.newTableColumns, (Predicate)new ColumnHasName(eligibleName = ColumnNameGenerator.generateColumnName())).isEmpty()) {
            }
            column.setName(eligibleName);
        }
    }

    protected Table createBaseTable(String tableName, List<Column> columns) {
        Table result = new Table(this.tableType);
        result.setColumns(columns);
        result.setName(tableName);
        return result;
    }

    protected void cloneMetadata(Table sourceTable, Table destTable) {
        for (TableMetadata m : sourceTable.getAllMetadata()) {
            logger.info("source metadata : " + m);
            if (!m.isInheritable()) continue;
            destTable.setMetadata(m);
        }
    }

    private List<Column> getAllColumnsExceptId() {
        ArrayList result = Lists.newArrayList(this.newTableColumns);
        if (this.tableToClone != null) {
            result.removeAll(this.tableToClone.getColumnsByType(new ColumnType[]{new IdColumnType()}));
        }
        for (Column col : result) {
            DataType type = this.columnAlterMap.get(col);
            if (type == null) continue;
            col.setDataType(type);
        }
        return result;
    }

    protected abstract void addIndexes(String var1, Collection<Column> var2);

    protected Column createIdColumn() {
        return IdColumnFactory.create();
    }

    public static class ColumnNameGenerator {
        public static String generateColumnName() {
            return RandomStringUtils.random((int)6, (boolean)true, (boolean)false).toLowerCase();
        }
    }
}

