/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.worker;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.dbutils.DbUtils;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.worker.ActivityStatus;
import org.gcube.data.analysis.tabulardata.operation.worker.ImmutableJob;
import org.gcube.data.analysis.tabulardata.operation.worker.ImmutableJobResult;
import org.gcube.data.analysis.tabulardata.operation.worker.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.OperationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseWorker
implements Worker {
    private static final Logger log = LoggerFactory.getLogger(BaseWorker.class);
    private ImmutableJob job;
    protected OperationInvocation invocation;

    public BaseWorker(OperationInvocation invocation) {
        this.invocation = invocation;
        this.job = new ImmutableJob(0.0f, ActivityStatus.INITIALIZING, invocation);
    }

    protected void inProgress(float progress) {
        this.job = new ImmutableJob(progress, ActivityStatus.IN_PROGRESS, this.job.getSourceInvocation());
    }

    protected void fail(OperationException exception) {
        this.job = new ImmutableJob(this.job.getProgress(), ActivityStatus.FAILED, this.job.getSourceInvocation(), new ImmutableJobResult(exception));
    }

    protected void succeed(Table resultTable) {
        this.job = new ImmutableJob(1.0f, ActivityStatus.SUCCEDED, this.job.getSourceInvocation(), new ImmutableJobResult(resultTable));
    }

    @Override
    public ImmutableJob getJob() {
        return this.job;
    }

    protected void executeSQLCommand(String sqlCommand, DatabaseConnectionProvider connectionProvider) throws OperationException {
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = connectionProvider.getConnection();
            stmt = conn.createStatement();
            log.debug("Executing SQL command: " + sqlCommand);
            stmt.execute(sqlCommand);
        }
        catch (SQLException e) {
            try {
                String msg = "Unable to execute sql command : " + sqlCommand;
                log.error(msg);
                throw new OperationException(msg, e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(stmt);
                DbUtils.closeQuietly((Connection)conn);
                throw throwable;
            }
        }
        DbUtils.closeQuietly((Statement)stmt);
        DbUtils.closeQuietly((Connection)conn);
    }

    protected void executeSQLBatchCommands(DatabaseConnectionProvider connectionProvider, String ... sqlCommands) throws OperationException {
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = connectionProvider.getConnection();
            stmt = conn.createStatement();
            for (int i = 0; i < sqlCommands.length; ++i) {
                log.debug("Adding to batch: " + sqlCommands[i]);
                stmt.addBatch(sqlCommands[i]);
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                String msg = "Unable to execute batch sql command";
                log.error(msg, (Throwable)e);
                throw new OperationException(msg, e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(stmt);
                DbUtils.closeQuietly((Connection)conn);
                throw throwable;
            }
        }
        DbUtils.closeQuietly((Statement)stmt);
        DbUtils.closeQuietly((Connection)conn);
    }
}

