package org.gcube.data.analysis.tabulardata.operation.factories.types;

import java.util.List;

import org.gcube.data.analysis.tabulardata.operation.factories.scopes.VoidScopedWorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.worker.EligibleOperation;
import org.gcube.data.analysis.tabulardata.operation.worker.OperationDescriptor.OperationScope;
import org.gcube.data.analysis.tabulardata.operation.worker.OperationDescriptor.OperationType;

public abstract class ImportWorkerFactory extends BaseWorkerFactory implements VoidScopedWorkerFactory {
	
	protected abstract List<Parameter> getParameters();
	
	@Override
	public EligibleOperation getEligibleOperation() {
		return new EligibleOperation(getOperationDescriptor(), getParameters());
	}
	
	@Override
	protected OperationScope getOperationScope() {
		return OperationScope.VOID;
	}
	
	@Override
	protected OperationType getOperationType() {
		return OperationType.IMPORT;
	}
		
}
