package org.gcube.data.analysis.tabulardata.operation.parameters.leaves;

import java.util.List;

import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.LeafParameter;

public class LocalizedTextChoiceParameter extends LeafParameter<LocalizedText> {

	private List<LocalizedText> labelChoices;
	
	@SuppressWarnings("unused")
	private LocalizedTextChoiceParameter() {}

	public LocalizedTextChoiceParameter(String identifier, String name, String description, Cardinality cardinality,
			List<LocalizedText> labelChoices) {
		super(identifier, name, description, cardinality);
		this.labelChoices = labelChoices;
	}

	public List<LocalizedText> getLabelChoices() {
		return labelChoices;
	}

	@Override
	public Class<LocalizedText> getParameterType() {
		return LocalizedText.class;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = super.hashCode();
		result = prime * result + ((labelChoices == null) ? 0 : labelChoices.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (!super.equals(obj))
			return false;
		if (getClass() != obj.getClass())
			return false;
		LocalizedTextChoiceParameter other = (LocalizedTextChoiceParameter) obj;
		if (labelChoices == null) {
			if (other.labelChoices != null)
				return false;
		} else if (!labelChoices.equals(other.labelChoices))
			return false;
		return true;
	}

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("LocalizedTextChoiceParameter [labelChoices=");
		builder.append(labelChoices);
		builder.append("]");
		return builder.toString();
	}

}
