package org.gcube.data.analysis.tabulardata.operation.parameters.leaves;

import java.util.List;

import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.table.TableType;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.LeafParameter;

public class TargetColumnParameter extends LeafParameter<ColumnReference> {

	private List<TableType> allowedTableTypes = null;

	private List<ColumnType> allowedColumnTypes = null;

	@SuppressWarnings("unused")
	private TargetColumnParameter() {}

	public TargetColumnParameter(String identifier, String name, String description, Cardinality cardinality,
			List<TableType> allowedTableTypes, List<ColumnType> allowedColumnTypes) {
		super(identifier, name, description, cardinality);
		this.allowedTableTypes = allowedTableTypes;
		this.allowedColumnTypes = allowedColumnTypes;
	}

	@Override
	public Class<ColumnReference> getParameterType() {
		return ColumnReference.class;
	}

	public List<TableType> getAllowedTableTypes() {
		return allowedTableTypes;
	}

	public List<ColumnType> getAllowedColumnTypes() {
		return allowedColumnTypes;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = super.hashCode();
		result = prime * result + ((allowedColumnTypes == null) ? 0 : allowedColumnTypes.hashCode());
		result = prime * result + ((allowedTableTypes == null) ? 0 : allowedTableTypes.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (!super.equals(obj))
			return false;
		if (getClass() != obj.getClass())
			return false;
		TargetColumnParameter other = (TargetColumnParameter) obj;
		if (allowedColumnTypes == null) {
			if (other.allowedColumnTypes != null)
				return false;
		} else if (!allowedColumnTypes.equals(other.allowedColumnTypes))
			return false;
		if (allowedTableTypes == null) {
			if (other.allowedTableTypes != null)
				return false;
		} else if (!allowedTableTypes.equals(other.allowedTableTypes))
			return false;
		return true;
	}

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("TargetColumnParameter [getIdentifier()=");
		builder.append(getIdentifier());
		builder.append(", getName()=");
		builder.append(getName());
		builder.append(", getDescription()=");
		builder.append(getDescription());
		builder.append(", getCardinality()=");
		builder.append(getCardinality());
		builder.append(", getParameterType()=");
		builder.append(getParameterType());
		builder.append(", getAllowedTableTypes()=");
		builder.append(getAllowedTableTypes());
		builder.append(", getAllowedColumnTypes()=");
		builder.append(getAllowedColumnTypes());
		builder.append("]");
		return builder.toString();
	}

}
