package org.gcube.data.analysis.tabulardata.operation.worker;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

import org.gcube.data.analysis.tabulardata.model.table.Table;

@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
public class CollateralTable {

	private Table table;

	private String tableName;
	
	@SuppressWarnings("unused")
	private CollateralTable() {}

	public CollateralTable(Table table, String tableName) {
		this.table = table;
		this.tableName = tableName;
	}

	public Table getTable() {
		return table;
	}

	public String getTableName() {
		return tableName;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((table == null) ? 0 : table.hashCode());
		result = prime * result + ((tableName == null) ? 0 : tableName.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		CollateralTable other = (CollateralTable) obj;
		if (table == null) {
			if (other.table != null)
				return false;
		} else if (!table.equals(other.table))
			return false;
		if (tableName == null) {
			if (other.tableName != null)
				return false;
		} else if (!tableName.equals(other.tableName))
			return false;
		return true;
	}
	
	

}
