package org.gcube.data.analysis.tabulardata.operation.worker;

import java.util.List;
import java.util.Map;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;

@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
public class EligibleOperation {

	private OperationDescriptor operationDescriptor;

	private List<Parameter> parameters;

	private TableId targetTableId = null;

	private ColumnLocalId targetColumnId = null;

	@SuppressWarnings("unused")
	private EligibleOperation() {
	}

	public EligibleOperation(OperationDescriptor operationDescriptor, List<Parameter> parameters) {
		this.operationDescriptor = operationDescriptor;
		this.parameters = parameters;
	}

	public EligibleOperation(OperationDescriptor operationDescriptor, List<Parameter> parameters, TableId targetTableId) {
		this.operationDescriptor = operationDescriptor;
		this.parameters = parameters;
		this.targetTableId = targetTableId;
	}

	public EligibleOperation(OperationDescriptor operationDescriptor, List<Parameter> parameters,
			TableId targetTableId, ColumnLocalId targetColumnId) {
		this.operationDescriptor = operationDescriptor;
		this.parameters = parameters;
		this.targetTableId = targetTableId;
		this.targetColumnId = targetColumnId;
	}

	public OperationDescriptor getOperationDescriptor() {
		return operationDescriptor;
	}

	public List<Parameter> getParameters() {
		return parameters;
	}

	public TableId getTargetTableId() {
		return targetTableId;
	}

	public ColumnLocalId getTargetColumnId() {
		return targetColumnId;
	}

	public OperationInvocation createOperationInvocation(Map<String, Object> parameterInstances) {
		// TODO-LF can add check on parameter keys
		return new OperationInvocation(targetTableId, targetColumnId, operationDescriptor, parameterInstances);
	}

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("EligibleOperation [operationDescriptor=");
		builder.append(operationDescriptor);
		builder.append(", parameters=");
		builder.append(parameters);
		builder.append(", targetTableId=");
		builder.append(targetTableId);
		builder.append(", targetColumnId=");
		builder.append(targetColumnId);
		builder.append("]");
		return builder.toString();
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((operationDescriptor == null) ? 0 : operationDescriptor.hashCode());
		result = prime * result + ((parameters == null) ? 0 : parameters.hashCode());
		result = prime * result + ((targetColumnId == null) ? 0 : targetColumnId.hashCode());
		result = prime * result + ((targetTableId == null) ? 0 : targetTableId.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		EligibleOperation other = (EligibleOperation) obj;
		if (operationDescriptor == null) {
			if (other.operationDescriptor != null)
				return false;
		} else if (!operationDescriptor.equals(other.operationDescriptor))
			return false;
		if (parameters == null) {
			if (other.parameters != null)
				return false;
		} else if (!parameters.equals(other.parameters))
			return false;
		if (targetColumnId == null) {
			if (other.targetColumnId != null)
				return false;
		} else if (!targetColumnId.equals(other.targetColumnId))
			return false;
		if (targetTableId == null) {
			if (other.targetTableId != null)
				return false;
		} else if (!targetTableId.equals(other.targetTableId))
			return false;
		return true;
	}

}
