package org.gcube.data.analysis.tabulardata.operation.worker;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
public class ImmutableJob implements Job {

	private float progress = 0;

	private ActivityStatus status = ActivityStatus.INITIALIZING;

	private OperationInvocation invocation;

	@XmlElementRef(type=ImmutableJobResult.class)
	private JobResult result = null;
	
	@SuppressWarnings("unused")
	private ImmutableJob() {}

	public ImmutableJob(float progress, ActivityStatus status, OperationInvocation invocation) {
		setProgress(progress);
		this.status = status;
		this.invocation = invocation;
	}

	public ImmutableJob(float progress, ActivityStatus status, OperationInvocation invocation, JobResult result) {
		setProgress(progress);
		this.status = status;
		this.invocation = invocation;
		this.result = result;
	}

	@Override
	public float getProgress() {
		return progress;
	}

	private void setProgress(float progress) {
		if (progress < 0 || progress > 1)
			throw new IllegalArgumentException("Progress must be between 0 and 1");
		this.progress = progress;
	}

	@Override
	public ActivityStatus getStatus() {
		return status;
	}

	@Override
	public OperationInvocation getSourceInvocation() {
		return invocation;
	}

	@Override
	public JobResult getResult() {
		return result;
	}

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("ImmutableJob [progress=");
		builder.append(progress);
		builder.append(", status=");
		builder.append(status);
		builder.append(", invocation=");
		builder.append(invocation);
		builder.append(", result=");
		builder.append(result);
		builder.append("]");
		return builder.toString();
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((invocation == null) ? 0 : invocation.hashCode());
		result = prime * result + Float.floatToIntBits(progress);
		result = prime * result + ((this.result == null) ? 0 : this.result.hashCode());
		result = prime * result + ((status == null) ? 0 : status.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		ImmutableJob other = (ImmutableJob) obj;
		if (invocation == null) {
			if (other.invocation != null)
				return false;
		} else if (!invocation.equals(other.invocation))
			return false;
		if (Float.floatToIntBits(progress) != Float.floatToIntBits(other.progress))
			return false;
		if (result == null) {
			if (other.result != null)
				return false;
		} else if (!result.equals(other.result))
			return false;
		if (status != other.status)
			return false;
		return true;
	}
	
	

}
