package org.gcube.data.analysis.tabulardata.operation.worker;

import java.util.List;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.OperationException;

import com.google.common.collect.ImmutableList;

@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
public class ImmutableJobResult implements JobResult {

	private Table output = null;

	private OperationException operationException = null;

	ImmutableList<CollateralTable> collateralTables;

	@SuppressWarnings("unused")
	private ImmutableJobResult() {
	}

	public ImmutableJobResult(Table output) {
		this.output = output;
	}

	public ImmutableJobResult(OperationException operationException) {
		this.operationException = operationException;
	}

	public ImmutableJobResult(Table outputTable, List<CollateralTable> collateralTables) {
		this.output = outputTable;
		this.collateralTables = ImmutableList.copyOf(collateralTables);
	}

	@Override
	public Table getOutput() {
		return output;
	}

	@Override
	public OperationException getException() {
		return operationException;
	}

	@Override
	public List<CollateralTable> getCollateralTables() {
		return collateralTables;
	}

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("ImmutableJobResult [output=");
		builder.append(output);
		builder.append(", operationException=");
		builder.append(operationException);
		builder.append("]");
		return builder.toString();
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((collateralTables == null) ? 0 : collateralTables.hashCode());
		result = prime * result + ((operationException == null) ? 0 : operationException.hashCode());
		result = prime * result + ((output == null) ? 0 : output.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		ImmutableJobResult other = (ImmutableJobResult) obj;
		if (collateralTables == null) {
			if (other.collateralTables != null)
				return false;
		} else if (!collateralTables.equals(other.collateralTables))
			return false;
		if (operationException == null) {
			if (other.operationException != null)
				return false;
		} else if (!operationException.equals(other.operationException))
			return false;
		if (output == null) {
			if (other.output != null)
				return false;
		} else if (!output.equals(other.output))
			return false;
		return true;
	}

}
