package org.gcube.data.analysis.tabulardata.operation.worker;

import java.util.Map;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.table.TableId;

@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
public class OperationInvocation {

	private TableId targetTableId;

	private ColumnLocalId targetColumnId;

	private OperationDescriptor operationDescriptor;

	private Map<String, Object> parameterInstances;

	@SuppressWarnings("unused")
	private OperationInvocation() {
	}

	public OperationInvocation(TableId targetTableId, ColumnLocalId targetColumnId,
			OperationDescriptor operationDescriptor, Map<String, Object> parameterInstances) {
		this.targetTableId = targetTableId;
		this.targetColumnId = targetColumnId;
		this.operationDescriptor = operationDescriptor;
		this.parameterInstances = parameterInstances;
	}

	public TableId getTargetTableId() {
		return targetTableId;
	}

	public ColumnLocalId getTargetColumnId() {
		return targetColumnId;
	}

	public OperationDescriptor getOperationDescriptor() {
		return operationDescriptor;
	}

	public Map<String, Object> getParameterInstances() {
		return parameterInstances;
	}

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("OperationInvocation [targetTableId=");
		builder.append(targetTableId);
		builder.append(", targetColumnId=");
		builder.append(targetColumnId);
		builder.append(", operationDescriptor=");
		builder.append(operationDescriptor);
		builder.append(", parameterInstances=");
		builder.append(parameterInstances);
		builder.append("]");
		return builder.toString();
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((operationDescriptor == null) ? 0 : operationDescriptor.hashCode());
		result = prime * result + ((parameterInstances == null) ? 0 : parameterInstances.hashCode());
		result = prime * result + ((targetColumnId == null) ? 0 : targetColumnId.hashCode());
		result = prime * result + ((targetTableId == null) ? 0 : targetTableId.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		OperationInvocation other = (OperationInvocation) obj;
		if (operationDescriptor == null) {
			if (other.operationDescriptor != null)
				return false;
		} else if (!operationDescriptor.equals(other.operationDescriptor))
			return false;
		if (parameterInstances == null) {
			if (other.parameterInstances != null)
				return false;
		} else if (!parameterInstances.equals(other.parameterInstances))
			return false;
		if (targetColumnId == null) {
			if (other.targetColumnId != null)
				return false;
		} else if (!targetColumnId.equals(other.targetColumnId))
			return false;
		if (targetTableId == null) {
			if (other.targetTableId != null)
				return false;
		} else if (!targetTableId.equals(other.targetTableId))
			return false;
		return true;
	}

}
