/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.factories.types;

import org.gcube.data.analysis.tabulardata.operation.worker.OperationDescriptor;
import org.gcube.data.analysis.tabulardata.operation.worker.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;

public abstract class BaseWorkerFactory
implements WorkerFactory {
    protected abstract String getOperationName();

    protected abstract String getOperationDescription();

    protected OperationDescriptor.OperationId getOperationId() {
        return new OperationDescriptor.OperationId(this.getClass());
    }

    protected abstract OperationDescriptor.OperationScope getOperationScope();

    protected abstract OperationDescriptor.OperationType getOperationType();

    @Override
    public OperationDescriptor getOperationDescriptor() {
        return new OperationDescriptor(this.getOperationId(), this.getOperationName(), this.getOperationDescription(), this.getOperationScope(), this.getOperationType());
    }

    protected <T> void checkParameterValue(String id, Class<T> type, OperationInvocation invocation) throws InvalidInvocationException {
        Object obj = invocation.getParameterInstances().get(id);
        if (obj == null) {
            throw new InvalidInvocationException(invocation, String.format("Parameter %s is missing", id));
        }
        Object typedParameter = null;
        try {
            typedParameter = obj;
        }
        catch (Exception e) {
            throw new InvalidInvocationException(invocation, e.getMessage());
        }
    }

    protected <T> T getParameterValue(String id, Class<T> type, OperationInvocation invocation) throws InvalidInvocationException {
        this.checkParameterValue(id, type, invocation);
        return (T)invocation.getParameterInstances().get(id);
    }

    protected void checkTableIdPresence(OperationInvocation invocation) throws InvalidInvocationException {
        if (invocation.getTargetTableId() == null) {
            throw new InvalidInvocationException(invocation, "Target table is missing");
        }
    }

    protected void checkColumnIdPresence(OperationInvocation invocation) throws InvalidInvocationException {
        if (invocation.getTargetColumnId() == null) {
            throw new InvalidInvocationException(invocation, "Target column is missing");
        }
    }
}

