/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.factories.types;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.operation.ImmutableOperationDescriptor;
import org.gcube.data.analysis.tabulardata.operation.OperationDescriptor;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.OperationScope;
import org.gcube.data.analysis.tabulardata.operation.OperationType;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.CompositeParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.LeafParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.ExpressionParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.MultivaluedStringParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.RegexpStringParameter;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;

public abstract class BaseWorkerFactory
implements WorkerFactory {
    protected abstract String getOperationName();

    protected abstract String getOperationDescription();

    protected OperationId getOperationId() {
        return new OperationId(this.getClass());
    }

    @Override
    public List<WorkerFactory> getPrecoditionValidations() {
        return Collections.emptyList();
    }

    protected abstract OperationScope getOperationScope();

    protected abstract OperationType getOperationType();

    @Override
    public OperationDescriptor getOperationDescriptor() {
        return new ImmutableOperationDescriptor(this.getOperationId(), this.getOperationName(), this.getOperationDescription(), this.getOperationScope(), this.getOperationType(), this.getParameters());
    }

    protected abstract List<Parameter> getParameters();

    private <T> void checkParameterValue(String id, Class<T> type, OperationInvocation invocation) throws InvalidInvocationException {
        Object obj = invocation.getParameterInstances().get(id);
        if (obj == null) {
            throw new InvalidInvocationException(invocation, String.format("Parameter %s is missing", id));
        }
        Object typedParameter = null;
        try {
            typedParameter = obj;
        }
        catch (Exception e) {
            throw new InvalidInvocationException(invocation, e.getMessage());
        }
    }

    private void checkParameter(LeafParameter<?> parameter, OperationInvocation invocation) throws InvalidInvocationException {
        this.checkParameterValue(parameter.getIdentifier(), parameter.getParameterType(), invocation);
    }

    private void checkParameters(List<Parameter> toCheckParams, Map<String, Object> paramInstances, OperationInvocation invocation) throws InvalidInvocationException {
        for (Parameter parameter : toCheckParams) {
            if (!(parameter.getCardinality().getMinimum() <= 0 || paramInstances.containsKey(parameter.getIdentifier()) && paramInstances.get(parameter.getIdentifier()) != null)) {
                throw new InvalidInvocationException(invocation, String.format("Parameter %s is missing or null", parameter.getIdentifier()));
            }
            if (parameter.getCardinality().getMinimum() > 1 && !(paramInstances.get(parameter.getIdentifier()) instanceof Iterable)) {
                throw new InvalidInvocationException(invocation, String.format("Parameter %s must be multiple", parameter.getIdentifier()));
            }
            if (parameter.getCardinality().getMaximum() == 1 && paramInstances.get(parameter.getIdentifier()) instanceof Iterable) {
                throw new InvalidInvocationException(invocation, String.format("Parameter %s cannot be multiple", parameter.getIdentifier()));
            }
            Object value = paramInstances.get(parameter.getIdentifier());
            if (value == null) continue;
            if (value instanceof Iterable) {
                for (Object obj : (Iterable)value) {
                    this.checkParameterInstance(obj, parameter, invocation);
                    if (!(parameter instanceof CompositeParameter)) continue;
                    this.checkParameters(((CompositeParameter)parameter).getParameters(), (Map)obj, invocation);
                }
                continue;
            }
            this.checkParameterInstance(value, parameter, invocation);
            if (!(parameter instanceof CompositeParameter)) continue;
            this.checkParameters(((CompositeParameter)parameter).getParameters(), (Map)value, invocation);
        }
    }

    private void checkParameterInstance(Object obj, Parameter parameter, OperationInvocation invocation) throws InvalidInvocationException {
        block10: {
            if (parameter instanceof LeafParameter) {
                LeafParameter leaf = (LeafParameter)parameter;
                if (!leaf.getParameterType().isAssignableFrom(obj.getClass())) {
                    throw new InvalidInvocationException(invocation, String.format("Invalid %s parameter instance class. Found %s, expected %s ", parameter.getIdentifier(), obj.getClass(), ((LeafParameter)parameter).getParameterType()));
                }
                try {
                    if (leaf instanceof ExpressionParameter && !((ExpressionParameter)leaf).validate((Expression)obj)) {
                        throw new Exception();
                    }
                    if (leaf instanceof MultivaluedStringParameter && !((MultivaluedStringParameter)leaf).validate((String)obj)) {
                        throw new Exception();
                    }
                    if (leaf instanceof RegexpStringParameter && !((RegexpStringParameter)leaf).validate((String)obj)) {
                        throw new Exception();
                    }
                    break block10;
                }
                catch (Exception e) {
                    throw new InvalidInvocationException(invocation, String.format("Parameter %s is invalid.", parameter.getIdentifier()));
                }
            }
            if (parameter instanceof CompositeParameter) {
                try {
                    Map map = (Map)obj;
                }
                catch (Exception e) {
                    throw new InvalidInvocationException(invocation, String.format("Parameter %s must implement Map<String,Object>", parameter.getIdentifier()));
                }
            }
        }
    }

    protected void performBaseChecks(OperationInvocation invocation) throws InvalidInvocationException {
        switch (this.getOperationScope()) {
            case COLUMN: {
                this.checkColumnIdPresence(invocation);
            }
            case TABLE: {
                this.checkTableIdPresence(invocation);
            }
        }
        this.checkParameters(this.getParameters(), invocation.getParameterInstances(), invocation);
    }

    private void checkTableIdPresence(OperationInvocation invocation) throws InvalidInvocationException {
        if (invocation.getTargetTableId() == null) {
            throw new InvalidInvocationException(invocation, "Target table is missing");
        }
    }

    private void checkColumnIdPresence(OperationInvocation invocation) throws InvalidInvocationException {
        if (invocation.getTargetColumnId() == null) {
            throw new InvalidInvocationException(invocation, "Target column is missing");
        }
    }
}

