package org.gcube.data.analysis.tabulardata.operation.worker.results.resources;

import java.net.URI;

public class ImmutableURIResult implements ResourceDescriptorResult {
	
	/**
	 * 
	 */
	private static final long serialVersionUID = -4754240010695558432L;

	private InternalURI uri;
	
	private ResourceScope resourceScope = ResourceScope.LOCAL;
	
	private String description;
	
		
	public ImmutableURIResult(URI uri, String description) {
		super();
		this.uri = new InternalURI(uri);
		this.description = description;
	}
	
	public ImmutableURIResult(URI uri, String description, ResourceScope resourceScope) {
		super();
		this.uri = new InternalURI(uri);
		this.description = description;
		this.resourceScope = resourceScope;
	}

	@Override
	public InternalURI getResource() {
		return uri;
	}

	@Override
	public String getDescription() {
		return description;
	}

	@Override
	public ResourceScope getResourceScope() {
		return resourceScope;
	}

	@Override
	public String toString() {
		return "ImmutableResourceDescriptorResult [uri=" + uri
				+ ", description=" + description + "]";
	}
	
}
