package org.gcube.data.analysis.tabulardata.operation.worker.results.resources;


public class ImmutableInlineTable implements ResourceDescriptorResult{

	/**
	 * 
	 */
	private static final long serialVersionUID = 2378033798749961208L;

	private InlineTable aTable;
	private String name;
	private String description;
	private ResourceScope resourceScope = ResourceScope.LOCAL;
	
	
	public ImmutableInlineTable(InlineTable aTable, String name, 
			String description) {
		super();
		this.aTable = aTable;
		this.description = description;
		this.name = name;
	}
	
	public ImmutableInlineTable(InlineTable aTable, String name, String description,
			ResourceScope resourceScope) {
		super();
		this.aTable = aTable;
		this.description = description;
		this.resourceScope = resourceScope;
		this.name = name;
	}

	@Override
	public InlineTable getResource() {
		return aTable;
	}

	@Override
	public String getDescription() {
		return description;
	}

	@Override
	public ResourceScope getResourceScope() {
		return resourceScope;
	}

	@Override
	public String getName() {
		return name;
	}
	
	
}
