/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.worker.results;

import java.util.ArrayList;
import java.util.List;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.worker.results.WorkerResult;

public class ImmutableWorkerResult
implements WorkerResult {
    private Table resultTable;
    private Table diffTable;
    private List<Table> collateralTables = new ArrayList<Table>();

    private ImmutableWorkerResult() {
    }

    public ImmutableWorkerResult(Table table) {
        this.resultTable = table;
    }

    public ImmutableWorkerResult(Table table, List<Table> collateralTables) {
        this.resultTable = table;
        this.collateralTables = collateralTables;
    }

    public ImmutableWorkerResult(Table resultTable, Table difftable, List<Table> collateralTables) {
        this.resultTable = resultTable;
        this.collateralTables = collateralTables;
        this.diffTable = difftable;
    }

    public ImmutableWorkerResult(Table resultTable, Table difftable) {
        this.resultTable = resultTable;
        this.diffTable = difftable;
    }

    @Override
    public Table getResultTable() {
        return this.resultTable;
    }

    @Override
    public Table getDiffTable() {
        return this.diffTable;
    }

    @Override
    public List<Table> getCollateralTables() {
        return this.collateralTables;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ImmutableWorkerResult [table=");
        builder.append(this.resultTable);
        builder.append(", diffTable=");
        builder.append(this.diffTable);
        builder.append(", collateralTables=");
        builder.append(this.collateralTables);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.collateralTables == null ? 0 : this.collateralTables.hashCode());
        result = 31 * result + (this.diffTable == null ? 0 : this.diffTable.hashCode());
        result = 31 * result + (this.resultTable == null ? 0 : this.resultTable.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImmutableWorkerResult other = (ImmutableWorkerResult)obj;
        if (this.collateralTables == null ? other.collateralTables != null : !this.collateralTables.equals(other.collateralTables)) {
            return false;
        }
        if (this.diffTable == null ? other.diffTable != null : !this.diffTable.equals((Object)other.diffTable)) {
            return false;
        }
        return !(this.resultTable == null ? other.resultTable != null : !this.resultTable.equals((Object)other.resultTable));
    }
}

