/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.csv.importer;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import net.sf.csv4j.CSVLineProcessor;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.factories.AttributeColumnFactory;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.datatype.TextType;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ColumnMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ImmutableLocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.NamesMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitializerProcessor
implements CSVLineProcessor {
    private Logger logger = LoggerFactory.getLogger(InitializerProcessor.class);
    private boolean tableCreated = false;
    private int rows = 0;
    private List<Column> columns = new ArrayList<Column>();
    private List<Boolean> fieldMask;
    private boolean skipError;
    private File outputFile;
    private static final char tempSeparator = ',';
    private static final char tempQuoting = '\"';
    private OutputStreamWriter streamWriter;

    public InitializerProcessor(List<Boolean> fieldMask, boolean skipError) throws IOException {
        this.fieldMask = fieldMask;
        this.skipError = skipError;
        if (this.skipError) {
            this.outputFile = File.createTempFile("modifiedFileImport", ".csv");
            this.streamWriter = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(this.outputFile)), Charset.forName("utf-8"));
        }
    }

    public void processHeaderLine(int lineNumber, List<String> fields) {
        this.onHeaderLine(lineNumber, fields);
    }

    public void processDataLine(int lineNumber, List<String> fields) {
        this.onDataLine(lineNumber, fields);
    }

    public boolean continueProcessing() {
        return !this.tableCreated || this.skipError;
    }

    public void onHeaderLine(int lineNumber, List<String> fields) {
        try {
            for (int i = 0; i < fields.size(); ++i) {
                if (this.fieldMask != null && !this.fieldMask.get(i).booleanValue()) continue;
                Column column = null;
                column = fields.get(i) != null && fields.get(i) != "" ? new AttributeColumnFactory().create((LocalizedText)new ImmutableLocalizedText(fields.get(i)), (DataType)new TextType()) : new AttributeColumnFactory().create((LocalizedText)new ImmutableLocalizedText("field" + i), (DataType)new TextType());
                this.columns.add(column);
            }
            this.tableCreated = true;
        }
        catch (Exception e) {
            this.logger.error("erorr reading the header line", (Throwable)e);
        }
    }

    public void onDataLine(int lineNumber, List<String> fields) {
        if (!this.tableCreated) {
            try {
                for (int i = 0; i < fields.size(); ++i) {
                    if (this.fieldMask != null && !this.fieldMask.get(i).booleanValue()) continue;
                    Column column = new AttributeColumnFactory().create((LocalizedText)new ImmutableLocalizedText("field" + i), (DataType)new TextType());
                    ArrayList<ImmutableLocalizedText> names = new ArrayList<ImmutableLocalizedText>();
                    names.add(new ImmutableLocalizedText("field" + i, "en"));
                    NamesMetadata nMeta = new NamesMetadata(names);
                    column.setMetadata((ColumnMetadata)nMeta);
                    this.columns.add(column);
                }
                this.tableCreated = true;
            }
            catch (Exception e) {
                this.logger.error("error reading data line", (Throwable)e);
            }
        }
        if (this.fieldMask != null && fields.size() != this.fieldMask.size()) {
            this.logger.trace("the line " + lineNumber + " is not correct");
            return;
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < fields.size(); ++i) {
            if (this.fieldMask != null && !this.fieldMask.get(i).booleanValue()) continue;
            buffer.append('\"' + fields.get(i) + '\"' + ',');
        }
        try {
            this.streamWriter.write(buffer.substring(0, buffer.length() - 1) + '\n');
        }
        catch (IOException e) {
            this.logger.warn("error writing line");
        }
    }

    public int getRows() {
        return this.rows;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    protected File getOutputFile() {
        return this.outputFile;
    }

    public void close() {
        try {
            if (this.streamWriter != null) {
                this.streamWriter.close();
            }
        }
        catch (IOException e) {
            this.logger.warn("erorr closing streamWriter", (Throwable)e);
        }
    }
}

