/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.data.replace;

import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.MalformedExpressionException;
import org.gcube.data.analysis.tabulardata.expression.TableReferenceReplacer;
import org.gcube.data.analysis.tabulardata.expression.evaluator.EvaluatorException;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sql.SQLExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.SQLHelper;
import org.gcube.data.analysis.tabulardata.operation.data.replace.ReplaceByExpressionFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.ImmutableWorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplaceByExpression
extends Worker {
    private static final Logger log = LoggerFactory.getLogger(ReplaceByExpression.class);
    private CubeManager cubeManager;
    private DatabaseConnectionProvider connectionProvider;
    private SQLExpressionEvaluatorFactory sqlEvaluatorFactory;
    private Table targetTable;
    private Column targetColumn;
    private Expression condition;
    private Expression value;
    private Table newTable;

    public ReplaceByExpression(OperationInvocation sourceInvocation, CubeManager cubeManager, DatabaseConnectionProvider connectionProvider, SQLExpressionEvaluatorFactory sqlEvaluatorFactory) {
        super(sourceInvocation);
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
        this.sqlEvaluatorFactory = sqlEvaluatorFactory;
    }

    protected WorkerResult execute() throws WorkerException {
        this.instantiateExecutionVariables();
        this.updateProgress(0.1f);
        this.newTable = this.cubeManager.createTable(this.targetTable.getTableType()).like(this.targetTable, true).create();
        this.updateProgress(0.5f);
        this.executeBatch();
        this.updateProgress(0.9f);
        return new ImmutableWorkerResult(this.newTable);
    }

    private void instantiateExecutionVariables() throws WorkerException {
        OperationInvocation invocation = this.getSourceInvocation();
        this.targetTable = this.cubeManager.getTable(invocation.getTargetTableId());
        this.targetColumn = this.targetTable.getColumnById(invocation.getTargetColumnId());
        this.condition = (Expression)invocation.getParameterInstances().get(ReplaceByExpressionFactory.CONDITION_PARAMETER.getIdentifier());
        this.value = (Expression)invocation.getParameterInstances().get(ReplaceByExpressionFactory.VALUE_PARAMETER.getIdentifier());
    }

    private String getUpdateStatement() throws WorkerException {
        try {
            Expression actualCondition = this.updateTableReferences(this.condition);
            Expression actualValue = this.updateTableReferences(this.value);
            String stmt = String.format("UPDATE %s SET %s = %s WHERE %s ", this.newTable.getName(), this.targetColumn.getName(), this.sqlEvaluatorFactory.getEvaluator(actualValue).evaluate(), this.sqlEvaluatorFactory.getEvaluator(actualCondition).evaluate());
            log.debug("To execute statement : " + stmt);
            return stmt;
        }
        catch (MalformedExpressionException e) {
            throw new WorkerException("Expression is not well formed", (Throwable)e);
        }
        catch (EvaluatorException e) {
            throw new WorkerException("Unable to evaluate expression", (Throwable)e);
        }
    }

    private void executeBatch() throws WorkerException {
        try {
            SQLHelper.executeSQLBatchCommands((DatabaseConnectionProvider)this.connectionProvider, (String[])new String[]{this.getUpdateStatement()});
        }
        catch (Exception e) {
            throw new WorkerException("Error occurred while executing SQL command", (Throwable)e);
        }
    }

    private Expression updateTableReferences(Expression e) throws MalformedExpressionException {
        TableReferenceReplacer replacer = new TableReferenceReplacer(e);
        for (ColumnReference original : replacer.getReferences(this.targetTable.getId())) {
            String columnName = this.targetTable.getColumnById(original.getColumnId()).getName();
            replacer.replaceColumnReference(original, this.newTable.getColumnReference(this.newTable.getColumnByName(columnName)));
        }
        return replacer.getExpression();
    }
}

