package org.gcube.data.analysis.tabulardata.operation.data.remove;

import java.util.ArrayList;

import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.type.IdColumnType;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.SQLHelper;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.ImmutableWorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;

public class RemoveRowsById extends Worker{

	CubeManager cubeManager;
	
	DatabaseConnectionProvider connectionProvider;

	Table targetTable;
	

	
	ArrayList<Object> ids=new ArrayList<Object>();
	
	Table newTable;
	
	public RemoveRowsById(OperationInvocation sourceInvocation, CubeManager cubeManager,
			DatabaseConnectionProvider connectionProvider) {
		super(sourceInvocation);
		this.cubeManager = cubeManager;
		this.connectionProvider = connectionProvider;
	}
	
	@Override
	protected WorkerResult execute() throws WorkerException {
		retrieveParameters();
		updateProgress(0.1f);
		createNewTable();
		updateProgress(0.5f);
		removeRows();
		return new ImmutableWorkerResult(newTable);
	}
	
	@SuppressWarnings("unchecked")
	private void removeRows() throws WorkerException{		
		Column idColumn=newTable.getColumnsByType(IdColumnType.class).get(0);
		String sqlCommand="DELETE FROM "+newTable.getName()+" WHERE "+idColumn.getName()+" = ? ";
		try{
			SQLHelper.iteratePreparedStatementOverColumnValues(idColumn, sqlCommand, connectionProvider, ids);
		}catch(Exception e){
			throw new WorkerException("Error occurred while performing deletion of selected tuples", e);
		}
	}
	
	private void createNewTable() {
		newTable = cubeManager.createTable(targetTable.getTableType()).like(targetTable, true).create();
	}
	
	@SuppressWarnings("unchecked")	
	private void retrieveParameters() {
		targetTable = cubeManager.getTable(getSourceInvocation().getTargetTableId());		
		for(Integer id : (Iterable<Integer>) getSourceInvocation().getParameterInstances().get(RemoveRowsByIdFactory.ID_PARAMETER.getIdentifier())){
			ids.add(id);
		}
//		ids=(List<Object>) getSourceInvocation().getParameterInstances().get(RemoveRowsByIdFactory.ID_PARAMETER.getIdentifier());
	}
}
