/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.data.add;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sql.SQLExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.IdColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.ValidationColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.table.TableType;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.data.add.AddColumn;
import org.gcube.data.analysis.tabulardata.operation.factories.types.TableTransformationWorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.ColumnTypeParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.DataTypeParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.LocalizedTextParameter;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;

@Singleton
public class AddColumnFactory
extends TableTransformationWorkerFactory {
    private static final OperationId OPERATION_ID = new OperationId(1005L);
    public static final DataTypeParameter DATA_TYPE = new DataTypeParameter("dataType", "Data Type", "To set data type", Cardinality.OPTIONAL);
    public static final ColumnTypeParameter COLUMN_TYPE = new ColumnTypeParameter("columnType", "Column type", "The type of the new column", Cardinality.ONE);
    public static final LocalizedTextParameter LABEL = new LocalizedTextParameter("label", "label", "To set label", Cardinality.OPTIONAL);
    private static List<Parameter> parameters = Arrays.asList(COLUMN_TYPE, DATA_TYPE, LABEL);
    @Inject
    private CubeManager cubeManager;
    @Inject
    private SQLExpressionEvaluatorFactory sqlEvaluatorFactory;
    @Inject
    private DatabaseConnectionProvider connectionProvider;

    public Worker createWorker(OperationInvocation invocation) throws InvalidInvocationException {
        this.performBaseChecks(invocation, this.cubeManager);
        this.checkAllowedColumnDataCombination(invocation);
        return new AddColumn(invocation, this.cubeManager, this.sqlEvaluatorFactory, this.connectionProvider);
    }

    protected String getOperationName() {
        return "Adds a column";
    }

    protected String getOperationDescription() {
        return "Adds a column to a table";
    }

    protected OperationId getOperationId() {
        return OPERATION_ID;
    }

    protected List<Parameter> getParameters() {
        return parameters;
    }

    private void checkAllowedColumnDataCombination(OperationInvocation invocation) throws InvalidInvocationException {
        DataType type;
        TableType tableType = this.cubeManager.getTable(invocation.getTargetTableId()).getTableType();
        Map params = invocation.getParameterInstances();
        ColumnType colType = (ColumnType)params.get(COLUMN_TYPE.getIdentifier());
        if (colType.equals((Object)new ValidationColumnType()) || colType.equals((Object)new IdColumnType())) {
            throw new InvalidInvocationException(invocation, String.format("Column type %s cannot be added by user", colType.getName()));
        }
        if (!tableType.getAllowedColumnTypes().contains(colType)) {
            throw new InvalidInvocationException(invocation, String.format("Passed column type %s is not allowed for target table type %s. Allowed types are %s.", colType.getName(), tableType.getName(), tableType.getAllowedColumnTypes()));
        }
        if (params.containsKey(DATA_TYPE.getIdentifier()) && !colType.isDataTypeAllowed(type = (DataType)params.get(DATA_TYPE.getIdentifier()))) {
            throw new InvalidInvocationException(invocation, String.format("Incompatible column type %s and data type %s. Allowed data types are %s.", colType.getName(), type.getName(), colType.getAllowedDataTypes()));
        }
    }
}

