/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.data.transformation;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sql.SQLExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.column.type.IdColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.BooleanType;
import org.gcube.data.analysis.tabulardata.model.datatype.DateType;
import org.gcube.data.analysis.tabulardata.model.datatype.IntegerType;
import org.gcube.data.analysis.tabulardata.model.datatype.NumericType;
import org.gcube.data.analysis.tabulardata.model.datatype.TextType;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDBoolean;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDDate;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDInteger;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDNumeric;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.SQLHelper;
import org.gcube.data.analysis.tabulardata.operation.data.transformation.AggregationFunction;
import org.gcube.data.analysis.tabulardata.operation.data.transformation.GroupByFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.ImmutableWorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;

public class GroupBy
extends Worker {
    CubeManager cubeManager;
    DatabaseConnectionProvider connectionProvider;
    SQLExpressionEvaluatorFactory sqlEvaluator;
    private List<Column> toAggregatewithDefault = new ArrayList<Column>();
    private List<Column> groupByColumns = new ArrayList<Column>();
    private Map<Column, AggregationFunction> toApplyAggregations = new HashMap<Column, AggregationFunction>();
    private Table targetTable;
    private Table newTable;

    public GroupBy(OperationInvocation sourceInvocation, CubeManager cubeManager, DatabaseConnectionProvider connectionProvider, SQLExpressionEvaluatorFactory sqlEvaluator) {
        super(sourceInvocation);
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
        this.sqlEvaluator = sqlEvaluator;
    }

    protected WorkerResult execute() throws WorkerException {
        this.retrieveParameters();
        this.updateProgress(0.1f);
        this.newTable = this.cubeManager.createTable(this.targetTable.getTableType()).like(this.targetTable, false).create();
        this.updateProgress(0.2f);
        String query = this.formQuery();
        this.updateProgress(0.3f);
        this.executeSQLCommand(query);
        this.updateProgress(0.9f);
        return new ImmutableWorkerResult(this.newTable);
    }

    private void retrieveParameters() {
        OperationInvocation invocation = this.getSourceInvocation();
        this.targetTable = this.cubeManager.getTable(invocation.getTargetTableId());
        Object toAggregateObj = invocation.getParameterInstances().get(GroupByFactory.GROUPBY_COLUMNS.getIdentifier());
        if (toAggregateObj instanceof Iterable) {
            for (Object ref : (Iterable)toAggregateObj) {
                this.groupByColumns.add(this.targetTable.getColumnById(((ColumnReference)ref).getColumnId()));
            }
        } else {
            this.groupByColumns.add(this.targetTable.getColumnById(((ColumnReference)toAggregateObj).getColumnId()));
        }
        if (invocation.getParameterInstances().containsKey(GroupByFactory.AGGREGATE_FUNCTION_TO_APPLY.getIdentifier())) {
            Object compositeObj = invocation.getParameterInstances().get(GroupByFactory.AGGREGATE_FUNCTION_TO_APPLY.getIdentifier());
            if (compositeObj instanceof Iterable) {
                for (Object mapObj : (Iterable)compositeObj) {
                    this.insertCompositeParameterValues((Map)mapObj);
                }
            } else {
                this.insertCompositeParameterValues((Map)compositeObj);
            }
        }
        for (Column col : this.targetTable.getColumnsExceptTypes(new Class[]{IdColumnType.class})) {
            if (this.groupByColumns.contains(col) || this.toApplyAggregations.containsKey(col)) continue;
            this.toAggregatewithDefault.add(col);
        }
    }

    private void insertCompositeParameterValues(Map<String, Object> composite) {
        ColumnReference ref = (ColumnReference)composite.get(GroupByFactory.TO_AGGREGATE_COLUMNS.getIdentifier());
        AggregationFunction function = AggregationFunction.valueOf(((LocalizedText)composite.get(GroupByFactory.FUNCTION_PARAMETER.getIdentifier())).getValue());
        this.toApplyAggregations.put(this.targetTable.getColumnById(ref.getColumnId()), function);
    }

    private String formQuery() throws WorkerException {
        StringBuilder theQuery = new StringBuilder();
        theQuery.append(String.format("INSERT INTO %s ", this.newTable.getName()));
        theQuery.append("(" + this.insertColumnsList() + ")");
        StringBuilder keyCSVList = new StringBuilder();
        for (Column column : this.groupByColumns) {
            keyCSVList.append(column.getName() + ",");
        }
        keyCSVList.deleteCharAt(keyCSVList.lastIndexOf(","));
        theQuery.append(" SELECT ");
        theQuery.append(keyCSVList + ",");
        for (Column column : this.toAggregatewithDefault) {
            theQuery.append(this.getDefaultValue(column) + ",");
        }
        for (Map.Entry entry : this.toApplyAggregations.entrySet()) {
            theQuery.append(this.getSQLFunction((Column)entry.getKey(), (AggregationFunction)((Object)entry.getValue())) + ",");
        }
        theQuery.deleteCharAt(theQuery.lastIndexOf(","));
        theQuery.append(String.format("FROM %s GROUP BY %s", this.targetTable.getName(), keyCSVList.toString()));
        return theQuery.toString();
    }

    private String insertColumnsList() {
        StringBuilder toReturn = new StringBuilder();
        for (Column col : this.groupByColumns) {
            toReturn.append(col.getName() + ",");
        }
        for (Column col : this.toAggregatewithDefault) {
            toReturn.append(col.getName() + ",");
        }
        for (Column col : this.toApplyAggregations.keySet()) {
            toReturn.append(col.getName() + ",");
        }
        toReturn.deleteCharAt(toReturn.lastIndexOf(","));
        return toReturn.toString();
    }

    private String getDefaultValue(Column col) throws WorkerException {
        TDBoolean toEvaluate = null;
        if (col.getDataType() instanceof BooleanType) {
            toEvaluate = new TDBoolean(false);
        } else if (col.getDataType() instanceof DateType) {
            toEvaluate = new TDDate(new Date(0L));
        } else if (col.getDataType() instanceof IntegerType) {
            toEvaluate = new TDInteger(Integer.valueOf(0));
        } else if (col.getDataType() instanceof NumericType) {
            toEvaluate = new TDNumeric(Float.valueOf(0.0f));
        } else if (col.getDataType() instanceof TextType) {
            toEvaluate = new TDText("ALL");
        } else {
            throw new WorkerException(String.format("Unable to define a default value for column %s (type %s)", col.getName(), col.getDataType().getName()));
        }
        return (String)this.sqlEvaluator.getEvaluator((Expression)toEvaluate).evaluate();
    }

    private String getSQLFunction(Column col, AggregationFunction func) {
        return String.format("%s(%s)", new Object[]{func, col.getName()});
    }

    private void executeSQLCommand(String theQuery) throws WorkerException {
        try {
            SQLHelper.executeSQLBatchCommands((DatabaseConnectionProvider)this.connectionProvider, (String[])new String[]{theQuery});
        }
        catch (SQLException e) {
            throw new WorkerException("Unable to execute sql command, see previous log.", (Throwable)e);
        }
    }
}

