/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.data.add;

import java.util.Map;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.TableReferenceReplacer;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sql.SQLExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.expression.functions.Cast;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.column.factories.BaseColumnFactory;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ImmutableLocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;
import org.gcube.data.analysis.tabulardata.operation.SQLHelper;
import org.gcube.data.analysis.tabulardata.operation.data.add.AddColumnFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.LeafParameter;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.data.analysis.tabulardata.operation.worker.results.ImmutableWorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.types.DataWorker;

public class AddColumn
extends DataWorker {
    private CubeManager cubeManager;
    private SQLExpressionEvaluatorFactory sqlEvaluatorFactory;
    private DatabaseConnectionProvider connectionProvider;
    private Table targetTable;
    private Column theNewColumn;
    private Table resultTable;
    private Table diffTable;
    private Expression toSetValue = null;

    public AddColumn(OperationInvocation sourceInvocation, CubeManager cubeManager, SQLExpressionEvaluatorFactory sqlEvaluatorFactory, DatabaseConnectionProvider connectionProvider) {
        super(sourceInvocation);
        this.cubeManager = cubeManager;
        this.sqlEvaluatorFactory = sqlEvaluatorFactory;
        this.connectionProvider = connectionProvider;
    }

    protected WorkerResult execute() throws WorkerException {
        this.updateProgress(0.1f, "Initiating");
        this.targetTable = this.cubeManager.getTable(this.getSourceInvocation().getTargetTableId());
        this.updateProgress(0.4f, "Creating column");
        this.theNewColumn = this.createColumn();
        this.resultTable = this.cubeManager.createTable(this.targetTable.getTableType()).like(this.targetTable, true).addColumn(this.theNewColumn).create();
        this.diffTable = this.cubeManager.createTable(this.targetTable.getTableType()).addColumn(this.theNewColumn).create();
        this.updateProgress(0.5f, "Filling with values");
        this.fillWithDefault();
        this.updateProgress(0.9f, "Finalizing");
        return new ImmutableWorkerResult(this.resultTable, this.diffTable);
    }

    private Column createColumn() {
        Map params = this.getSourceInvocation().getParameterInstances();
        ColumnType colType = (ColumnType)params.get(AddColumnFactory.COLUMN_TYPE.getIdentifier());
        DataType dataType = null;
        dataType = params.containsKey(AddColumnFactory.DATA_TYPE.getIdentifier()) ? (DataType)params.get(AddColumnFactory.DATA_TYPE.getIdentifier()) : colType.getDefaultDataType();
        Object label = null;
        label = params.containsKey(AddColumnFactory.LABEL.getIdentifier()) ? (LocalizedText)params.get(AddColumnFactory.LABEL.getIdentifier()) : new ImmutableLocalizedText("New Column");
        return BaseColumnFactory.getFactory((ColumnType)colType).create((LocalizedText)label, dataType);
    }

    private void initializeValueExpression() {
        try {
            this.toSetValue = (Expression)OperationHelper.getParameter((LeafParameter)AddColumnFactory.VALUE_PARAMETER, (OperationInvocation)this.getSourceInvocation());
            TableReferenceReplacer replacer = new TableReferenceReplacer(this.toSetValue);
            replacer.replaceTableId(this.targetTable.getId(), this.resultTable.getId());
            this.toSetValue = new Cast(replacer.getExpression(), this.theNewColumn.getDataType());
        }
        catch (Throwable t) {
            this.toSetValue = this.theNewColumn.getDataType().getDefaultValue();
        }
    }

    private void fillWithDefault() throws WorkerException {
        this.initializeValueExpression();
        String stmt = String.format("UPDATE %s SET %s = %s", this.resultTable.getName(), this.theNewColumn.getName(), this.sqlEvaluatorFactory.getEvaluator(this.toSetValue).evaluate());
        try {
            SQLHelper.executeSQLBatchCommands((DatabaseConnectionProvider)this.connectionProvider, (String[])new String[]{stmt});
        }
        catch (Exception e) {
            throw new WorkerException("Error occurred while executing SQL command " + stmt, (Throwable)e);
        }
    }
}

