/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.data.add;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.TableReferenceReplacer;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sql.SQLExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.column.factories.BaseColumnFactory;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ImmutableLocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;
import org.gcube.data.analysis.tabulardata.operation.SQLHelper;
import org.gcube.data.analysis.tabulardata.operation.data.add.AddColumnFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.LeafParameter;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.OperationAbortedException;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.data.analysis.tabulardata.operation.worker.results.ImmutableWorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.types.ColumnCreatorWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddColumn
extends ColumnCreatorWorker {
    private static Logger logger = LoggerFactory.getLogger(AddColumn.class);
    private CubeManager cubeManager;
    private SQLExpressionEvaluatorFactory sqlEvaluatorFactory;
    private DatabaseConnectionProvider connectionProvider;
    private Table targetTable;
    private Column theNewColumn;
    private Table resultTable;
    private Table diffTable;
    private Expression toSetValue = null;
    private Expression condition = null;

    public AddColumn(OperationInvocation sourceInvocation, CubeManager cubeManager, SQLExpressionEvaluatorFactory sqlEvaluatorFactory, DatabaseConnectionProvider connectionProvider) {
        super(sourceInvocation);
        this.cubeManager = cubeManager;
        this.sqlEvaluatorFactory = sqlEvaluatorFactory;
        this.connectionProvider = connectionProvider;
    }

    protected WorkerResult execute() throws WorkerException, OperationAbortedException {
        this.updateProgress(0.1f, "Initiating");
        this.targetTable = this.cubeManager.getTable(this.getSourceInvocation().getTargetTableId());
        this.updateProgress(0.4f, "Creating column");
        this.theNewColumn = this.createColumn();
        this.checkAborted();
        this.resultTable = this.cubeManager.createTable(this.targetTable.getTableType()).like(this.targetTable, true).addColumn(this.theNewColumn).create();
        this.diffTable = this.cubeManager.createTable(this.targetTable.getTableType()).addColumn(this.theNewColumn).create();
        this.updateProgress(0.5f, "Filling with values");
        this.checkAborted();
        this.fillWithData();
        this.updateProgress(0.9f, "Finalizing");
        return new ImmutableWorkerResult(this.resultTable, this.diffTable);
    }

    private Column createColumn() {
        Map params = this.getSourceInvocation().getParameterInstances();
        ColumnType colType = (ColumnType)params.get(AddColumnFactory.COLUMN_TYPE.getIdentifier());
        DataType dataType = null;
        dataType = params.containsKey(AddColumnFactory.DATA_TYPE.getIdentifier()) ? (DataType)params.get(AddColumnFactory.DATA_TYPE.getIdentifier()) : colType.getDefaultDataType();
        Object label = null;
        label = params.containsKey(AddColumnFactory.LABEL.getIdentifier()) ? (LocalizedText)params.get(AddColumnFactory.LABEL.getIdentifier()) : new ImmutableLocalizedText("New Column");
        return BaseColumnFactory.getFactory((ColumnType)colType).create((LocalizedText)label, dataType);
    }

    private void initializeValueExpression() {
        TableReferenceReplacer replacer;
        try {
            this.toSetValue = (Expression)OperationHelper.getParameter((LeafParameter)AddColumnFactory.VALUE_PARAMETER, (OperationInvocation)this.getSourceInvocation());
            replacer = new TableReferenceReplacer(this.toSetValue);
            replacer.replaceTableId(this.targetTable.getId(), this.resultTable.getId());
            this.toSetValue = replacer.getExpression();
        }
        catch (Throwable t) {
            this.toSetValue = this.theNewColumn.getDataType().getDefaultValue();
        }
        try {
            this.condition = (Expression)OperationHelper.getParameter((LeafParameter)AddColumnFactory.CONDITION_PARAMETER, (OperationInvocation)this.getSourceInvocation());
            replacer = new TableReferenceReplacer(this.condition);
            replacer.replaceTableId(this.targetTable.getId(), this.resultTable.getId());
            this.condition = replacer.getExpression();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void fillWithData() throws WorkerException {
        this.initializeValueExpression();
        ArrayList<String> toExecuteStatements = new ArrayList<String>();
        if (this.condition == null) {
            toExecuteStatements.add(String.format("UPDATE %s SET %s = %s", this.resultTable.getName(), this.theNewColumn.getName(), this.sqlEvaluatorFactory.getEvaluator(this.toSetValue).evaluate()));
        } else {
            try {
                toExecuteStatements.add(String.format("UPDATE %s SET %s = %s WHERE true", this.resultTable.getName(), this.theNewColumn.getName(), this.sqlEvaluatorFactory.getEvaluator((Expression)this.theNewColumn.getDataType().getDefaultValue()).evaluate()));
                String fromString = "";
                TableReferenceReplacer replacer = new TableReferenceReplacer(this.condition);
                Set tableIds = replacer.getTableIds();
                if (tableIds.size() > 1) {
                    StringBuilder builder = new StringBuilder();
                    for (TableId id : tableIds) {
                        if (id.equals((Object)this.resultTable.getId())) continue;
                        builder.append(this.cubeManager.getTable(id).getName() + ",");
                    }
                    fromString = "FROM " + builder.deleteCharAt(builder.lastIndexOf(",")).toString();
                }
                toExecuteStatements.add(String.format("UPDATE %s SET %s = %s %s WHERE %s", this.resultTable.getName(), this.theNewColumn.getName(), this.sqlEvaluatorFactory.getEvaluator(this.toSetValue).evaluate(), fromString, this.sqlEvaluatorFactory.getEvaluator(this.condition).evaluate()));
            }
            catch (Exception e) {
                throw new WorkerException("Unable to use condition statment", (Throwable)e);
            }
        }
        try {
            SQLHelper.executeSQLBatchCommands((DatabaseConnectionProvider)this.connectionProvider, (String[])toExecuteStatements.toArray(new String[toExecuteStatements.size()]));
        }
        catch (SQLException e) {
            SQLException sql = e.getNextException();
            logger.debug("SQL Exception : ", (Throwable)e);
            logger.debug("Next Exception : ", (Throwable)sql);
            throw new WorkerException("Error occurred while executing SQL command ", (Throwable)sql);
        }
    }

    public List<ColumnLocalId> getCreatedColumns() {
        return Collections.singletonList(this.theNewColumn.getLocalId());
    }
}

