/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.data.transformation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableCreator;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.column.factories.TimeDimensionColumnFactory;
import org.gcube.data.analysis.tabulardata.model.column.type.IdColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.TimeDimensionColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.ValidationColumnType;
import org.gcube.data.analysis.tabulardata.model.metadata.column.PeriodTypeMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.relationship.ColumnRelationship;
import org.gcube.data.analysis.tabulardata.model.relationship.ImmutableColumnRelationship;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.time.PeriodType;
import org.gcube.data.analysis.tabulardata.operation.QueryProgress;
import org.gcube.data.analysis.tabulardata.operation.SQLHelper;
import org.gcube.data.analysis.tabulardata.operation.data.transformation.AggregationFunction;
import org.gcube.data.analysis.tabulardata.operation.data.transformation.GroupByFactory;
import org.gcube.data.analysis.tabulardata.operation.data.transformation.TemporalAggregationFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.data.analysis.tabulardata.operation.worker.results.ImmutableWorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.types.DataWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemporalAggregationWorker
extends DataWorker {
    private static Logger logger = LoggerFactory.getLogger(TemporalAggregationWorker.class);
    CubeManager cubeManager;
    DatabaseConnectionProvider connectionProvider;
    private List<Column> groupByColumns = new ArrayList<Column>();
    private Map<Column, AggregationFunction> toApplyAggregations = new HashMap<Column, AggregationFunction>();
    private Table targetTable;
    private Column targetColumn;
    private Table newTable;
    private Column newTimeColumn;
    private String estimationQuery;
    private PeriodType sourcePeriod;
    private PeriodType targetPeriod;

    public TemporalAggregationWorker(OperationInvocation sourceInvocation, CubeManager cubeManager, DatabaseConnectionProvider connectionProvider) {
        super(sourceInvocation);
        this.connectionProvider = connectionProvider;
        this.cubeManager = cubeManager;
    }

    protected WorkerResult execute() throws WorkerException {
        this.updateProgress(0.02f, "Initializing");
        this.retrieveParameters();
        this.updateProgress(0.03f, "Generating query");
        String insertQuery = this.generateInsertQuery();
        this.updateProgress(0.05f, "Executing aggregation");
        this.executeSQLCommand(insertQuery, this.estimationQuery, this.newTable, "Executing aggregation", 0.9f);
        this.updateProgress(0.95f, "Preparing results");
        return new ImmutableWorkerResult(this.newTable);
    }

    private void retrieveParameters() {
        OperationInvocation invocation = this.getSourceInvocation();
        this.targetTable = this.cubeManager.getTable(invocation.getTargetTableId());
        this.targetColumn = this.targetTable.getColumnById(invocation.getTargetColumnId());
        this.sourcePeriod = ((PeriodTypeMetadata)this.targetColumn.getMetadata(PeriodTypeMetadata.class)).getType();
        this.targetPeriod = PeriodType.valueOf((String)((String)invocation.getParameterInstances().get(TemporalAggregationFactory.TIME_DIMENSION_AGGR.getIdentifier())));
        Object toAggregateObj = invocation.getParameterInstances().get(TemporalAggregationFactory.KEY_COLUMNS.getIdentifier());
        if (toAggregateObj != null) {
            if (toAggregateObj instanceof Iterable) {
                for (Object ref : (Iterable)toAggregateObj) {
                    this.groupByColumns.add(this.targetTable.getColumnById(((ColumnReference)ref).getColumnId()));
                }
            } else {
                this.groupByColumns.add(this.targetTable.getColumnById(((ColumnReference)toAggregateObj).getColumnId()));
            }
        } else {
            this.groupByColumns = Collections.emptyList();
        }
        if (invocation.getParameterInstances().containsKey(TemporalAggregationFactory.AGGREGATE_FUNCTION_TO_APPLY.getIdentifier())) {
            Object compositeObj = invocation.getParameterInstances().get(TemporalAggregationFactory.AGGREGATE_FUNCTION_TO_APPLY.getIdentifier());
            if (compositeObj instanceof Iterable) {
                for (Object mapObj : (Iterable)compositeObj) {
                    this.insertCompositeParameterValues((Map)mapObj);
                }
            } else {
                this.insertCompositeParameterValues((Map)compositeObj);
            }
        }
        TableCreator tc = this.cubeManager.createTable(this.targetTable.getTableType()).like(this.targetTable, false);
        Column previousCol = null;
        for (Column col : this.targetTable.getColumnsExceptTypes(new Class[]{IdColumnType.class, ValidationColumnType.class})) {
            if (col.getLocalId().equals((Object)this.targetColumn.getLocalId())) {
                TimeDimensionColumnFactory tdFactory = (TimeDimensionColumnFactory)TimeDimensionColumnFactory.getFactory((ColumnType)new TimeDimensionColumnType());
                this.newTimeColumn = tdFactory.create(this.targetPeriod);
                Table timeCodelistTable = this.cubeManager.getTimeTable(this.targetPeriod);
                this.newTimeColumn.setRelationship((ColumnRelationship)new ImmutableColumnRelationship(timeCodelistTable.getId(), timeCodelistTable.getColumnByName(this.targetPeriod.getName()).getLocalId()));
                if (previousCol != null) {
                    tc.addColumnAfter(this.newTimeColumn, previousCol);
                } else {
                    tc.addColumnFirst(this.newTimeColumn);
                }
            }
            if (!this.groupByColumns.contains(col) && !this.toApplyAggregations.containsKey(col)) {
                tc.removeColumn(col);
                continue;
            }
            previousCol = col;
        }
        this.newTable = tc.create();
    }

    private String generateInsertQuery() {
        String hlTableName = this.sourcePeriod.getName() + "_" + this.targetPeriod.getName();
        String sourcePeriodIdCol = this.sourcePeriod.getName() + "_id";
        String targetPeriodIdCol = this.targetPeriod.getName() + "_id";
        StringBuilder insertColumn = new StringBuilder();
        StringBuilder selectCSVList = new StringBuilder();
        StringBuilder groupCSVList = new StringBuilder();
        if (!this.groupByColumns.isEmpty()) {
            for (Column col : this.groupByColumns) {
                selectCSVList.append("target.").append(col.getName()).append(" as ").append(col.getName()).append(",");
                groupCSVList.append(col.getName()).append(",");
                insertColumn.append(col.getName()).append(",");
            }
            selectCSVList.deleteCharAt(selectCSVList.lastIndexOf(","));
        }
        groupCSVList.append(this.newTimeColumn.getName());
        StringBuilder selectQuery = new StringBuilder();
        selectQuery.append(" SELECT ");
        if (selectCSVList.length() != 0) {
            selectQuery.append(selectCSVList + ",");
        }
        for (Map.Entry<Column, AggregationFunction> entry : this.toApplyAggregations.entrySet()) {
            selectQuery.append(this.getSQLFunction(entry.getKey(), entry.getValue()) + ",");
            insertColumn.append(entry.getKey().getName()).append(",");
        }
        selectQuery.append("hl.").append(targetPeriodIdCol).append(" as ").append(this.newTimeColumn.getName());
        insertColumn.append(this.newTimeColumn.getName()).append(",");
        insertColumn.deleteCharAt(insertColumn.lastIndexOf(","));
        selectQuery.append(String.format(" FROM %s as target, %s as hl WHERE target.%s= hl.%s GROUP BY %s", this.targetTable.getName(), hlTableName, this.targetColumn.getName(), sourcePeriodIdCol, groupCSVList.toString()));
        this.estimationQuery = selectQuery.toString();
        return String.format("INSERT INTO %s(%s) %s", this.newTable.getName(), insertColumn.toString(), selectQuery.toString());
    }

    private void insertCompositeParameterValues(Map<String, Object> composite) {
        ColumnReference ref = (ColumnReference)composite.get(GroupByFactory.TO_AGGREGATE_COLUMNS.getIdentifier());
        AggregationFunction function = AggregationFunction.valueOf(((LocalizedText)composite.get(GroupByFactory.FUNCTION_PARAMETER.getIdentifier())).getValue());
        this.toApplyAggregations.put(this.targetTable.getColumnById(ref.getColumnId()), function);
    }

    private String getSQLFunction(Column col, AggregationFunction func) {
        return String.format("%1$s(target.%2$s) as %2$s ", new Object[]{func, col.getName()});
    }

    private void executeSQLCommand(String insertQuery, String estimationQuery, Table newTable, String humanReadableProgress, float percentForInsert) throws WorkerException {
        try {
            float startProgress = this.getProgress();
            int extimatedCount = SQLHelper.getCountEstimation((DatabaseConnectionProvider)this.connectionProvider, (String)estimationQuery);
            QueryProgress progress = SQLHelper.SQLInsertCommandWithProgress((Table)newTable, (String)insertQuery, (int)extimatedCount, (DatabaseConnectionProvider)this.connectionProvider);
            float progressValue = 0.0f;
            while (true) {
                float f;
                progressValue = progress.getProgress();
                if (f < 1.0f) {
                    float newProgress = startProgress + percentForInsert * progressValue;
                    this.updateProgress(newProgress, humanReadableProgress);
                    Thread.sleep(1000L);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            logger.error("Error occurred while executing SQL Command", (Throwable)e);
            throw new WorkerException("Error occurred while executing SQL Command", (Throwable)e);
        }
    }
}

