/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.data.transformation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableCreator;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.composite.aggregation.Avg;
import org.gcube.data.analysis.tabulardata.expression.composite.aggregation.Count;
import org.gcube.data.analysis.tabulardata.expression.composite.aggregation.Max;
import org.gcube.data.analysis.tabulardata.expression.composite.aggregation.Min;
import org.gcube.data.analysis.tabulardata.expression.composite.aggregation.ST_Extent;
import org.gcube.data.analysis.tabulardata.expression.composite.aggregation.Sum;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sql.SQLExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.column.type.IdColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.GeometryType;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.QueryProgress;
import org.gcube.data.analysis.tabulardata.operation.SQLHelper;
import org.gcube.data.analysis.tabulardata.operation.data.transformation.AggregationFunction;
import org.gcube.data.analysis.tabulardata.operation.data.transformation.GroupByFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.OperationAbortedException;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.data.analysis.tabulardata.operation.worker.results.ImmutableWorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.types.DataWorker;

public class GroupBy
extends DataWorker {
    CubeManager cubeManager;
    DatabaseConnectionProvider connectionProvider;
    SQLExpressionEvaluatorFactory sqlEvaluator;
    private List<Column> groupByColumns = new ArrayList<Column>();
    private Map<Column, AggregationFunction> toApplyAggregations = new HashMap<Column, AggregationFunction>();
    private Table targetTable;
    private Table newTable;
    private String estimationQuery;

    public GroupBy(OperationInvocation sourceInvocation, CubeManager cubeManager, DatabaseConnectionProvider connectionProvider, SQLExpressionEvaluatorFactory sqlEvaluator) {
        super(sourceInvocation);
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
        this.sqlEvaluator = sqlEvaluator;
    }

    protected WorkerResult execute() throws WorkerException, OperationAbortedException {
        this.retrieveParameters();
        this.updateProgress(0.02f, "Initializing");
        this.updateProgress(0.03f, "Analyzing structure");
        this.checkAborted();
        String insertQuery = this.formQuery();
        this.updateProgress(0.05f, "Creating grouped data");
        this.checkAborted();
        this.executeSQLCommand(insertQuery, this.estimationQuery, this.newTable, "Grouping data", 0.9f);
        this.updateProgress(0.95f, "Finalizing");
        return new ImmutableWorkerResult(this.newTable);
    }

    private void retrieveParameters() {
        OperationInvocation invocation = this.getSourceInvocation();
        this.targetTable = this.cubeManager.getTable(invocation.getTargetTableId());
        Object toAggregateObj = invocation.getParameterInstances().get(GroupByFactory.GROUPBY_COLUMNS.getIdentifier());
        if (toAggregateObj instanceof Iterable) {
            for (Object ref : (Iterable)toAggregateObj) {
                this.groupByColumns.add(this.targetTable.getColumnById(((ColumnReference)ref).getColumnId()));
            }
        } else {
            this.groupByColumns.add(this.targetTable.getColumnById(((ColumnReference)toAggregateObj).getColumnId()));
        }
        if (invocation.getParameterInstances().containsKey(GroupByFactory.AGGREGATE_FUNCTION_TO_APPLY.getIdentifier())) {
            Object compositeObj = invocation.getParameterInstances().get(GroupByFactory.AGGREGATE_FUNCTION_TO_APPLY.getIdentifier());
            if (compositeObj instanceof Iterable) {
                for (Object mapObj : (Iterable)compositeObj) {
                    this.insertCompositeParameterValues((Map)mapObj);
                }
            } else {
                this.insertCompositeParameterValues((Map)compositeObj);
            }
        }
        TableCreator tc = this.cubeManager.createTable(this.targetTable.getTableType()).like(this.targetTable, false);
        for (Column col : this.targetTable.getColumnsExceptTypes(new Class[]{IdColumnType.class})) {
            if (this.groupByColumns.contains(col) || this.toApplyAggregations.containsKey(col)) continue;
            tc.removeColumn(col);
        }
        this.newTable = tc.create();
    }

    private void insertCompositeParameterValues(Map<String, Object> composite) {
        ColumnReference ref = (ColumnReference)composite.get(GroupByFactory.TO_AGGREGATE_COLUMNS.getIdentifier());
        AggregationFunction function = AggregationFunction.valueOf(((LocalizedText)composite.get(GroupByFactory.FUNCTION_PARAMETER.getIdentifier())).getValue());
        this.toApplyAggregations.put(this.targetTable.getColumnById(ref.getColumnId()), function);
    }

    private String formQuery() throws WorkerException {
        StringBuilder theQuery = new StringBuilder();
        StringBuilder keyCSVList = new StringBuilder();
        for (Column column : this.groupByColumns) {
            keyCSVList.append(column.getName() + ",");
        }
        keyCSVList.deleteCharAt(keyCSVList.lastIndexOf(","));
        theQuery.append(" SELECT ");
        theQuery.append(keyCSVList + ",");
        for (Map.Entry entry : this.toApplyAggregations.entrySet()) {
            theQuery.append(this.getSQLFunction((Column)entry.getKey(), this.targetTable, (AggregationFunction)((Object)entry.getValue())) + ",");
        }
        theQuery.deleteCharAt(theQuery.lastIndexOf(","));
        theQuery.append(String.format(" FROM %s GROUP BY %s", this.targetTable.getName(), keyCSVList.toString()));
        this.estimationQuery = theQuery.toString();
        return String.format("INSERT INTO %s (%s) %s", this.newTable.getName(), this.insertColumnsList(), this.estimationQuery);
    }

    private String insertColumnsList() {
        StringBuilder toReturn = new StringBuilder();
        for (Column col : this.groupByColumns) {
            toReturn.append(col.getName() + ",");
        }
        for (Column col : this.toApplyAggregations.keySet()) {
            toReturn.append(col.getName() + ",");
        }
        toReturn.deleteCharAt(toReturn.lastIndexOf(","));
        return toReturn.toString();
    }

    private String getSQLFunction(Column col, Table table, AggregationFunction func) {
        ST_Extent expr = null;
        if (col.getDataType() instanceof GeometryType) {
            expr = new ST_Extent((Expression)table.getColumnReference(col));
        } else {
            switch (func) {
                case AVG: {
                    expr = new Avg((Expression)table.getColumnReference(col));
                    break;
                }
                case COUNT: {
                    expr = new Count((Expression)table.getColumnReference(col));
                    break;
                }
                case MAX: {
                    expr = new Max((Expression)table.getColumnReference(col));
                    break;
                }
                case MIN: {
                    expr = new Min((Expression)table.getColumnReference(col));
                    break;
                }
                case SUM: {
                    expr = new Sum((Expression)table.getColumnReference(col));
                }
            }
        }
        return (String)this.sqlEvaluator.getEvaluator((Expression)expr).evaluate();
    }

    private void executeSQLCommand(String insertQuery, String estimationQuery, Table newTable, String humanReadableProgress, float percentForInsert) throws WorkerException {
        try {
            float startProgress = this.getProgress();
            int extimatedCount = SQLHelper.getCountEstimation((DatabaseConnectionProvider)this.connectionProvider, (String)estimationQuery);
            QueryProgress progress = SQLHelper.SQLInsertCommandWithProgress((Table)newTable, (String)insertQuery, (int)extimatedCount, (DatabaseConnectionProvider)this.connectionProvider);
            float progressValue = 0.0f;
            while (true) {
                float f;
                progressValue = progress.getProgress();
                if (f < 1.0f) {
                    float newProgress = startProgress + percentForInsert * progressValue;
                    this.updateProgress(newProgress, humanReadableProgress);
                    Thread.sleep(1000L);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            throw new WorkerException("Error occurred while executing SQL Command", (Throwable)e);
        }
    }
}

