/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.labels;

import java.util.ArrayList;
import java.util.List;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.exceptions.NoSuchTableException;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableMetaCreator;
import org.gcube.data.analysis.tabulardata.metadata.NoSuchMetadataException;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.NamesMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.TableMetadata;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.labels.AddTableNameFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.data.analysis.tabulardata.operation.worker.results.EmptyType;
import org.gcube.data.analysis.tabulardata.operation.worker.types.MetadataWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddTableName
extends MetadataWorker {
    private static final Logger log = LoggerFactory.getLogger(AddTableName.class);
    private CubeManager cubeManager;
    private LocalizedText nameToSet = null;

    public AddTableName(CubeManager cubeManager, OperationInvocation invocation) {
        super(invocation);
        this.cubeManager = cubeManager;
    }

    protected EmptyType execute() throws WorkerException {
        this.retrieveNameToSet();
        this.updateProgress(0.3f, "Adding label metadata");
        this.createTableWithNewLabel();
        return EmptyType.instance();
    }

    private void retrieveNameToSet() {
        this.nameToSet = (LocalizedText)this.getSourceInvocation().getParameterInstances().get(AddTableNameFactory.NAME_LABEL_PARAMETER.getIdentifier());
    }

    private Table createTableWithNewLabel() {
        TableMetaCreator tmc = this.cubeManager.modifyTableMeta(this.getSourceInvocation().getTargetTableId());
        NamesMetadata oldNamesMetadata = this.getOldNamesMetadata();
        List oldTexts = oldNamesMetadata.getTexts();
        ArrayList<LocalizedText> newTexts = new ArrayList<LocalizedText>(oldTexts);
        newTexts.add(this.nameToSet);
        log.debug("Setting names: " + newTexts);
        NamesMetadata newNamesMetadata = new NamesMetadata(newTexts);
        tmc.setTableMetadata(new TableMetadata[]{newNamesMetadata});
        return tmc.create();
    }

    private NamesMetadata getOldNamesMetadata() {
        try {
            return (NamesMetadata)this.cubeManager.getTable(this.getSourceInvocation().getTargetTableId()).getMetadata(NamesMetadata.class);
        }
        catch (NoSuchTableException e) {
            throw new RuntimeException("Provided target table id does not exist");
        }
        catch (NoSuchMetadataException e) {
            return new NamesMetadata(new ArrayList());
        }
    }
}

